/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.hateoas.hal.http.converter.module.impl;

import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.eusashead.hateoas.hal.adapter.RepresentationReader;
import net.eusashead.hateoas.hal.adapter.RepresentationWriter;
import net.eusashead.hateoas.hal.http.converter.module.HalHttpMessageConverterModule;

public class ManualAdapterModuleImpl
implements HalHttpMessageConverterModule {
    private final Map<Class<?>, RepresentationWriter<?>> writers = new HashMap();
    private final Map<Class<?>, RepresentationReader<?>> readers = new HashMap();

    @Override
    public boolean canRead(Class<?> type) {
        return this.readers.containsKey(type);
    }

    @Override
    public boolean canWrite(Class<?> type) {
        return this.writers.containsKey(type);
    }

    @Override
    public ReadableRepresentation write(Object target, RepresentationFactory factory) {
        RepresentationWriter<?> writer = this.writers.get(target.getClass());
        if (writer != null) {
            return writer.write(target, factory);
        }
        throw new IllegalArgumentException(String.format("Cannot write object of type %s.", target.getClass()));
    }

    @Override
    public Object read(ReadableRepresentation representation, Class<?> type) {
        RepresentationReader<?> reader = this.readers.get(type);
        if (reader != null) {
            return reader.read(representation, type);
        }
        throw new IllegalArgumentException(String.format("Cannot read object of type %s.", type));
    }

    public void registerReader(RepresentationReader<?> reader) {
        Class<?> type = this.getGenericType(reader, (Type)((Object)RepresentationReader.class));
        if (type == null) {
            throw new IllegalArgumentException("Could not determine type of RepresentationWriter<?> using reflection. Please log a bug report.");
        }
        this.readers.put(type, reader);
    }

    public void registerWriter(RepresentationWriter<?> writer) {
        Class<?> type = this.getGenericType(writer, (Type)((Object)RepresentationWriter.class));
        if (type == null) {
            throw new IllegalArgumentException("Could not determine type of RepresentationWriter<?> using reflection. Please log a bug report.");
        }
        this.writers.put(type, writer);
    }

    private Class<?> getGenericType(Object target, Type targetType) {
        Type[] genericInterfaces;
        Class type = null;
        Type[] typeArray = genericInterfaces = target.getClass().getGenericInterfaces();
        int n = genericInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Type interf = typeArray[n2];
            ParameterizedType t = (ParameterizedType)interf;
            if (t.getRawType() == targetType) {
                type = (Class)t.getActualTypeArguments()[0];
            }
            ++n2;
        }
        return type;
    }
}

