/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.hateoas.hal.http.converter.module.impl;

import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import net.eusashead.hateoas.hal.adapter.RepresentationReader;
import net.eusashead.hateoas.hal.adapter.RepresentationWriter;
import net.eusashead.hateoas.hal.adapter.annotation.RepresentationReaderAdapter;
import net.eusashead.hateoas.hal.adapter.annotation.RepresentationWriterAdapter;
import net.eusashead.hateoas.hal.http.converter.module.HalHttpMessageConverterModule;

public class AnnotationAdapterModuleImpl
implements HalHttpMessageConverterModule {
    @Override
    public boolean canRead(Class<?> type) {
        return type.isAnnotationPresent(RepresentationReaderAdapter.class);
    }

    @Override
    public boolean canWrite(Class<?> type) {
        return type.isAnnotationPresent(RepresentationWriterAdapter.class);
    }

    @Override
    public ReadableRepresentation write(Object target, RepresentationFactory factory) {
        RepresentationWriterAdapter adapter = target.getClass().getAnnotation(RepresentationWriterAdapter.class);
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("Cannot write object of type %s.", target.getClass()));
        }
        try {
            RepresentationWriter<?> writer = adapter.value().newInstance();
            return writer.write(target, factory);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object read(ReadableRepresentation representation, Class<?> type) {
        RepresentationReaderAdapter adapter = type.getAnnotation(RepresentationReaderAdapter.class);
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("Cannot read object of type %s.", type));
        }
        try {
            RepresentationReader<?> reader = adapter.value().newInstance();
            return reader.read(representation, type);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

