/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.hateoas.hal.http.converter;

import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.eusashead.hateoas.hal.http.converter.module.HalHttpMessageConverterModule;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class HalHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    public static final Charset CHARSET = Charset.forName("UTF-8");
    public static MediaType HAL_JSON = new MediaType("application", "hal+json", CHARSET);
    public static MediaType HAL_XML = new MediaType("application", "hal+xml", CHARSET);
    private final RepresentationFactory factory;
    private final List<HalHttpMessageConverterModule> modules = new ArrayList<HalHttpMessageConverterModule>();

    public HalHttpMessageConverter(RepresentationFactory factory) {
        super(new MediaType[]{HAL_JSON, HAL_XML});
        this.factory = factory;
    }

    public boolean canRead(Class<?> type, MediaType mediaType) {
        if (!this.canRead(mediaType)) {
            return false;
        }
        if (ReadableRepresentation.class.isAssignableFrom(type)) {
            return true;
        }
        return this.hasReaderModule(type);
    }

    public boolean canWrite(Class<?> type, MediaType mediaType) {
        if (!this.canWrite(mediaType)) {
            return false;
        }
        if (ReadableRepresentation.class.isAssignableFrom(type)) {
            return true;
        }
        return this.hasWriterModule(type);
    }

    protected Object readInternal(Class<? extends Object> type, HttpInputMessage message) throws IOException, HttpMessageNotReadableException {
        ReadableRepresentation representation = this.factory.readRepresentation((Reader)new InputStreamReader(message.getBody()));
        if (ReadableRepresentation.class.isAssignableFrom(type)) {
            return representation;
        }
        if (this.hasReaderModule(type)) {
            return this.getReaderModule(type).read(representation, type);
        }
        throw new IllegalArgumentException(String.format("Cannot read class %s", type));
    }

    protected boolean supports(Class<?> type) {
        throw new UnsupportedOperationException();
    }

    protected void writeInternal(Object target, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        ReadableRepresentation rep = this.getRepresentation(target);
        MediaType contentType = outputMessage.getHeaders().getContentType();
        String mediaType = String.valueOf(contentType.getType()) + "/" + contentType.getSubtype();
        OutputStreamWriter writer = new OutputStreamWriter(outputMessage.getBody());
        rep.toString(mediaType, (Writer)writer);
    }

    private ReadableRepresentation getRepresentation(Object target) {
        if (ReadableRepresentation.class.isAssignableFrom(target.getClass())) {
            return (ReadableRepresentation)target;
        }
        if (this.hasWriterModule(target.getClass())) {
            return this.getWriterModule(target.getClass()).write(target, this.factory);
        }
        throw new IllegalArgumentException(String.format("Unable to create Representation from object of type %s", target.getClass()));
    }

    private boolean hasReaderModule(Class<?> type) {
        HalHttpMessageConverterModule module = this.getReaderModule(type);
        return module != null;
    }

    private boolean hasWriterModule(Class<?> type) {
        HalHttpMessageConverterModule module = this.getWriterModule(type);
        return module != null;
    }

    private HalHttpMessageConverterModule getReaderModule(Class<?> type) {
        for (HalHttpMessageConverterModule module : this.modules) {
            if (!module.canRead(type)) continue;
            return module;
        }
        return null;
    }

    private HalHttpMessageConverterModule getWriterModule(Class<?> type) {
        for (HalHttpMessageConverterModule module : this.modules) {
            if (!module.canWrite(type)) continue;
            return module;
        }
        return null;
    }

    public void addModule(HalHttpMessageConverterModule module) {
        this.modules.add(module);
    }

    public List<HalHttpMessageConverterModule> getModules() {
        return Collections.unmodifiableList(this.modules);
    }
}

