package net.eusashead.hateoas.hal.response.impl;

/*
 * #[license]
 * spring-halbuilder
 * %%
 * Copyright (C) 2013 Eusa's Head
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * %[license]
 */


import javax.servlet.http.HttpServletRequest;

import net.eusashead.hateoas.hal.response.HalResponseBuilder;

import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

import com.theoryinpractise.halbuilder.api.RepresentationFactory;

/**
 * Enables a {@link HalGetResponseEntityBuilder} to
 * be injected as a method parameter in a 
 * Spring MVC controller, pre-populated
 * with the HTTP request and other variables
 * @author patrickvk
 *
 */
public class HalResponseBuilderHandlerMethodArgumentResolver implements HandlerMethodArgumentResolver {

	private final RepresentationFactory representationFactory;

	/**
	 * Supply a {@link RepresentationFactory} and
	 * the name of the HTTP request variable 
	 * that users can use to specify the
	 * included fields in a request
	 * @param representationFactory
	 * @param fieldsParam
	 */
	public HalResponseBuilderHandlerMethodArgumentResolver(
			RepresentationFactory representationFactory) {
		super();
		this.representationFactory = representationFactory;
	}

	/* (non-Javadoc)
	 * @see org.springframework.web.method.support.HandlerMethodArgumentResolver#resolveArgument(org.springframework.core.MethodParameter, org.springframework.web.method.support.ModelAndViewContainer, org.springframework.web.context.request.NativeWebRequest, org.springframework.web.bind.support.WebDataBinderFactory)
	 */
	@Override
	public Object resolveArgument(MethodParameter parameter,
			ModelAndViewContainer container, NativeWebRequest request,
			WebDataBinderFactory factory) throws Exception {

		return new HalResponseBuilderImpl(
				representationFactory, request.getNativeRequest(HttpServletRequest.class));
	}

	/* (non-Javadoc)
	 * @see org.springframework.web.method.support.HandlerMethodArgumentResolver#supportsParameter(org.springframework.core.MethodParameter)
	 */
	@Override
	public boolean supportsParameter(MethodParameter parameter) {
		return HalResponseBuilder.class.isAssignableFrom(parameter.getParameterType());
	}

}