package net.eusashead.hateoas.hal.response.impl;

/*
 * #[license]
 * spring-halbuilder
 * %%
 * Copyright (C) 2013 Eusa's Head
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * %[license]
 */

import javax.servlet.http.HttpServletRequest;

import net.eusashead.hateoas.response.ResponseBuilder;
import net.eusashead.hateoas.response.impl.AbstractEntityResponseBuilder;

import org.springframework.http.ResponseEntity;

import com.theoryinpractise.halbuilder.api.Representation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;

/**
 * Abstract class from which HAL {@link Representation}
 * {@link ResponseEntity} can be constructed using
 * HALBuilder
 * 
 * @author patrickvk
 *
 */
public abstract class AbstractHalResponseBuilder extends AbstractEntityResponseBuilder<Representation, Representation> {

	/**
	 * RepresentationFactor to create HAL Representations
	 */
	protected final RepresentationFactory representationFactory;

	/**
	 * URI of the response entity
	 */
	protected final String uri;

	/**
	 * Construct a {@link ResponseBuilder} with
	 * the supplied {@link RepresentationFactory}
	 * and {@link HttpServletRequest}
	 * @param representationFactory {@link RepresentationFactory} for constructing the HAL {@link Representation}
	 * @param request incoming {@link HttpServletRequest} for which the response is built for
	 */
	public AbstractHalResponseBuilder(RepresentationFactory representationFactory, HttpServletRequest request) {

		super(request);

		// Set the RepresentationFactory
		this.representationFactory = representationFactory;

		// Create the URI for the resource
		StringBuilder uriBuilder = new StringBuilder(request.getRequestURI());
		if (request.getQueryString() != null) {
			uriBuilder.append("?");
			uriBuilder.append(request.getQueryString());
		}
		this.uri = uriBuilder.toString();

		// Create representation
		this.entity = representationFactory.newRepresentation(uri);
	}

	@Override
	protected void assertVerb() {
		if (!(this.request.getMethod().equals("GET") || this.request.getMethod().equals("HEAD"))) {
			throw new RuntimeException("This ResponseBuilder handles GET or HEAD requests only.");
		}
	};
	
}
