package net.eusashead.hateoas.hal.http.converter.module.impl;

/*
 * #[license]
 * spring-halbuilder
 * %%
 * Copyright (C) 2013 Eusa's Head
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * %[license]
 */

import net.eusashead.hateoas.hal.adapter.RepresentationReader;
import net.eusashead.hateoas.hal.adapter.RepresentationWriter;
import net.eusashead.hateoas.hal.adapter.annotation.RepresentationReaderAdapter;
import net.eusashead.hateoas.hal.adapter.annotation.RepresentationWriterAdapter;
import net.eusashead.hateoas.hal.http.converter.module.HalHttpMessageConverterModule;

import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;


/**
 * Implementation of {@link HalHttpMessageConverterModule}
 * that allows manual registration of {@link RepresentationWriter}
 * and {@link RepresentationReader} for a given {@link Class}
 * @author patrickvk
 *
 */
public class AnnotationAdapterModuleImpl implements HalHttpMessageConverterModule {

	/* (non-Javadoc)
	 * @see net.eusashead.hateoas.converter.hal.module.HalHttpMessageConverterModule#canRead(java.lang.Class)
	 */
	@Override
	public boolean canRead(Class<?> type) {
		return type.isAnnotationPresent(RepresentationReaderAdapter.class);
	}

	/* (non-Javadoc)
	 * @see net.eusashead.hateoas.converter.hal.module.HalHttpMessageConverterModule#canWrite(java.lang.Class)
	 */
	@Override
	public boolean canWrite(Class<?> type) {
		return type.isAnnotationPresent(RepresentationWriterAdapter.class);
	}

	/* (non-Javadoc)
	 * @see net.eusashead.hateoas.converter.hal.module.HalHttpMessageConverterModule#write(java.lang.Object, com.theoryinpractise.halbuilder.api.RepresentationFactory)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public ReadableRepresentation write(Object target,
			RepresentationFactory factory) {
		RepresentationWriterAdapter adapter = target.getClass().getAnnotation(RepresentationWriterAdapter.class);
		if (adapter == null) {
			throw new IllegalArgumentException(String.format("Cannot write object of type %s.", target.getClass()));
		}
		try {
			RepresentationWriter<Object> writer = (RepresentationWriter<Object>) adapter.value().newInstance();
			return writer.write(target, factory);
		} catch (InstantiationException e) {
			throw new RuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		}
	}

	/* (non-Javadoc)
	 * @see net.eusashead.hateoas.converter.hal.module.HalHttpMessageConverterModule#read(com.theoryinpractise.halbuilder.api.ReadableRepresentation, java.lang.Class)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public Object read(ReadableRepresentation representation, Class<?> type) {
		RepresentationReaderAdapter adapter = type.getAnnotation(RepresentationReaderAdapter.class);
		if (adapter == null) {
			throw new IllegalArgumentException(String.format("Cannot read object of type %s.", type));
		}
		try {
			RepresentationReader<Object> reader = (RepresentationReader<Object>) adapter.value().newInstance();
			return reader.read(representation, type);
		} catch (InstantiationException e) {
			throw new RuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		}
	}

}
