package net.eusashead.hateoas.hal.http.converter.module;

/*
 * #[license]
 * spring-halbuilder
 * %%
 * Copyright (C) 2013 Eusa's Head
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * %[license]
 */

import net.eusashead.hateoas.hal.http.converter.HalHttpMessageConverter;

import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;

/**
 * Extends the functionality of 
 * the {@link HalHttpMessageConverter}
 * by adding modules to handle
 * specific Java types
 * @author patrickvk
 *
 */
public interface HalHttpMessageConverterModule {
	
	/** 
	 * Can this module
	 * read the supplied type?
	 * @param type
	 * @return
	 */
	boolean canRead(Class<?> type);
	
	/**
	 * Can this module write the
	 * supplied type?
	 * @param type
	 * @return
	 */
	boolean canWrite(Class<?> type);
	
	/**
	 * Convert an object to
	 * a {@link ReadableRepresentation} 
	 * using the supplied 
	 * {@link RepresentationFactory}
	 * @param target the {@link Object} to convert
	 * @param factory the {@link RepresentationFactory} to use
	 * @return the {@link ReadableRepresentation} of the converted object
	 */
	ReadableRepresentation write(Object target, RepresentationFactory factory);

	/**
	 * Convert a HAL {@link ReadableRepresentation}
	 * to an object 
	 * @param representation Hal {@link ReadableRepresentation} to convert
	 * @param type
	 * @return object represented by the {@link ReadableRepresentation}
	 */
	Object read(ReadableRepresentation representation, Class<?> type);
	
}
