package net.eusashead.hateoas.hal.adapter;

/*
 * #[license]
 * spring-halbuilder
 * %%
 * Copyright (C) 2013 Eusa's Head
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * %[license]
 */

import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;

/**
 * Implementations of this class
 * convert Java objects into HAL
 * {@link ReadableRepresentation}  
 * @author patrickvk
 *
 * @param <T> the type that this class converts to a {@link ReadableRepresentation}
 */
public interface RepresentationWriter<T> {

	/**
	 * Convert an object to
	 * a {@link ReadableRepresentation} 
	 * using the supplied 
	 * {@link RepresentationFactory}
	 * @param t the object to convert
	 * @param factory the {@link RepresentationFactory} to use
	 * @return the {@link ReadableRepresentation} of the converted object
	 */
	Representation write(T t, RepresentationFactory factory);
	
}
