package net.eusashead.hateoas.hal.adapter;

/*
 * #[license]
 * spring-halbuilder
 * %%
 * Copyright (C) 2013 Eusa's Head
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * %[license]
 */

import com.theoryinpractise.halbuilder.api.ReadableRepresentation;

/**
 * Implementations of this class
 * retrieve an object from
 * a HAL {@link ReadableRepresentation}
 * @author patrickvk
 *
 * @param <T> the generic type handled by this reader
 */
public interface RepresentationReader<T> {

	/**
	 * Convert a HAL {@link ReadableRepresentation}
	 * to an object of type T
	 * @param representation Hal {@link ReadableRepresentation} to convert
	 * @param type {@link Class} read by this reader
	 * @return object represented by the {@link ReadableRepresentation}
	 */
	T read(ReadableRepresentation representation, Class<? extends T> type);

}