/*
 * Decompiled with CFR 0.152.
 */
package net.eunjae.android.aevent.manager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import net.eunjae.android.aevent.annotation.ASticky;
import net.eunjae.android.aevent.event.StickyEvent;
import net.eunjae.android.aevent.util.CompareUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AStickyEventManager {
    private static volatile AStickyEventManager instance = null;
    private EventMap eventMap = new EventMap();
    private HashMap<Class<?>, ArrayList<Method>> annotatedMethodsByClass = new HashMap();
    private static Comparator<StickyEvent> comparator = new Comparator<StickyEvent>(){

        @Override
        public int compare(StickyEvent lhs, StickyEvent rhs) {
            if (lhs._getTimestamp() > rhs._getTimestamp()) {
                return 1;
            }
            if (lhs._getTimestamp() < rhs._getTimestamp()) {
                return -1;
            }
            return 0;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AStickyEventManager getInstance() {
        if (instance != null) return instance;
        Class<AStickyEventManager> clazz = AStickyEventManager.class;
        synchronized (AStickyEventManager.class) {
            if (instance != null) return instance;
            instance = new AStickyEventManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private AStickyEventManager() {
    }

    public void post(StickyEvent event) {
        boolean willAddEvent;
        if (event._isEventAllowDuplicates()) {
            willAddEvent = true;
        } else {
            boolean bl = willAddEvent = !this.eventMap.hasEvent(event);
        }
        if (willAddEvent) {
            this.eventMap.add(event._getEventName(), event);
        }
    }

    public void cancelAll(String eventName) {
        this.eventMap.remove(eventName);
    }

    public void firePendingEvents(Object subscriber) {
        ArrayList<Method> methods = this.getAnnotatedMethodsRecursively(subscriber.getClass());
        this.eventMap.fireEvents(subscriber, methods);
    }

    private ArrayList<Method> getAnnotatedMethodsRecursively(Class<?> klass) {
        if (klass == null || klass.equals(Class.class)) {
            this.annotatedMethodsByClass.put(klass, null);
            return null;
        }
        if (this.annotatedMethodsByClass.containsKey(klass)) {
            return this.annotatedMethodsByClass.get(klass);
        }
        ArrayList<Method> result = new ArrayList<Method>();
        Method[] methods = klass.getDeclaredMethods();
        if (methods == null) {
            this.annotatedMethodsByClass.put(klass, null);
            return null;
        }
        for (Method method : methods) {
            ASticky annotation = method.getAnnotation(ASticky.class);
            if (annotation == null) continue;
            method.setAccessible(true);
            result.add(method);
        }
        ArrayList<Method> methodsFromSuperClass = this.getAnnotatedMethodsRecursively(klass.getSuperclass());
        if (methodsFromSuperClass != null) {
            result.addAll(methodsFromSuperClass);
        }
        this.annotatedMethodsByClass.put(klass, result);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventMap {
        private HashMap<String, ArrayList<StickyEvent>> map = new HashMap();

        private EventMap() {
        }

        public void add(String eventName, StickyEvent event) {
            if (!this.map.containsKey(eventName)) {
                this.map.put(eventName, new ArrayList());
            }
            this.map.get(eventName).add(event);
        }

        public void fireEvents(Object subscriber, ArrayList<Method> methods) {
            ArrayList<StickyEvent> eventsToFire = new ArrayList<StickyEvent>();
            HashMap<String, Method> methodMap = new HashMap<String, Method>();
            for (Method method : methods) {
                String eventName;
                ASticky annotation = method.getAnnotation(ASticky.class);
                if (annotation == null || !this.map.containsKey(eventName = annotation.value())) continue;
                for (StickyEvent event : this.map.get(eventName)) {
                    if (event._getEventTarget() != null && !subscriber.getClass().equals(event._getEventTarget())) continue;
                    eventsToFire.add(event);
                }
                methodMap.put(eventName, method);
            }
            Collections.sort(eventsToFire, comparator);
            for (StickyEvent event : eventsToFire) {
                Method method = (Method)methodMap.get(event._getEventName());
                this.fireEvent(event, subscriber, method);
                this.remove(event);
            }
        }

        private void fireEvent(StickyEvent event, Object subscriber, Method method) {
            block5: {
                Object[] eventData = event._getEventData();
                Class<?>[] parameterTypes = method.getParameterTypes();
                try {
                    if (!(parameterTypes != null && parameterTypes.length != 0 || eventData != null && eventData.length != 0)) {
                        method.invoke(subscriber, new Object[0]);
                        break block5;
                    }
                    if (eventData != null && parameterTypes.length == eventData.length) {
                        method.invoke(subscriber, eventData);
                        break block5;
                    }
                    throw new IllegalArgumentException(String.format("Method %s requires %d parameters, but you posted %s parameter! So method hasn't been excuted.", method.toString(), parameterTypes.length, eventData == null ? 0 : eventData.length));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }

        public void remove(String eventName) {
            this.map.remove(eventName);
        }

        private void remove(StickyEvent event) {
            this.map.get(event._getEventName()).remove(event);
            if (this.map.get(event._getEventName()).size() == 0) {
                this.map.remove(event._getEventName());
            }
        }

        public boolean hasEvent(StickyEvent event) {
            if (this.map.containsKey(event._getEventName())) {
                ArrayList<StickyEvent> events = this.map.get(event._getEventName());
                for (StickyEvent item : events) {
                    if (!CompareUtil.isSame(item._getEventTarget(), event._getEventTarget()) || !CompareUtil.isSame(item._getEventData(), event._getEventData())) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

