/*
 * Decompiled with CFR 0.152.
 */
package net.eunjae.android.aevent.manager;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import net.eunjae.android.aevent.annotation.AEvent;
import net.eunjae.android.aevent.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AEventManager {
    private static volatile AEventManager instance = null;
    private ArrayList<WeakReference<Object>> subscribers;
    private HashMap<Class<?>, ArrayList<Method>> annotatedMethodsByClass = new HashMap();
    private static Comparator<Method> comparator = new Comparator<Method>(){

        @Override
        public int compare(Method lhs, Method rhs) {
            return lhs.getName().compareTo(rhs.getName());
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AEventManager getInstance() {
        if (instance != null) return instance;
        Class<AEventManager> clazz = AEventManager.class;
        synchronized (AEventManager.class) {
            if (instance != null) return instance;
            instance = new AEventManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private AEventManager() {
        this.subscribers = new ArrayList();
    }

    public void register(Object subscriber) {
        if (subscriber == null) {
            return;
        }
        for (WeakReference<Object> item : this.subscribers) {
            if (!subscriber.equals(item.get())) continue;
            return;
        }
        this.subscribers.add(new WeakReference<Object>(subscriber));
    }

    public void unregister(Object subscriber) {
        if (subscriber == null) {
            return;
        }
        Iterator<WeakReference<Object>> iterator = this.subscribers.iterator();
        while (iterator.hasNext()) {
            WeakReference<Object> reference = iterator.next();
            if (!subscriber.equals(reference.get())) continue;
            iterator.remove();
        }
    }

    public void post(Event event) {
        ArrayList<WeakReference<Object>> copiedSubscribers = new ArrayList<WeakReference<Object>>(this.subscribers);
        for (WeakReference<Object> item : copiedSubscribers) {
            Object subscriber = item.get();
            if (subscriber == null) continue;
            ArrayList<Method> methods = this.getAnnotatedMethodsRecursively(subscriber.getClass());
            this.fireEvents(subscriber, event, methods);
        }
    }

    private void fireEvents(Object subscriber, Event event, ArrayList<Method> methods) {
        if (event._getEventTarget() != null && !event._getEventTarget().equals(subscriber.getClass())) {
            return;
        }
        ArrayList<Method> methodsToFire = new ArrayList<Method>();
        for (Method method : methods) {
            AEvent annotation = method.getAnnotation(AEvent.class);
            if (annotation == null) continue;
            String eventName = annotation.value();
            if (!event._getEventName().equals(eventName)) continue;
            methodsToFire.add(method);
        }
        Collections.sort(methodsToFire, comparator);
        Object[] eventData = event._getEventData();
        for (Method method : methodsToFire) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            try {
                if (!(parameterTypes != null && parameterTypes.length != 0 || eventData != null && eventData.length != 0)) {
                    method.invoke(subscriber, new Object[0]);
                    continue;
                }
                if (eventData != null && parameterTypes.length == eventData.length) {
                    method.invoke(subscriber, eventData);
                    continue;
                }
                throw new IllegalArgumentException(String.format("Method %s requires %d parameters, but you posted %s parameter! So method hasn't been excuted.", method.toString(), parameterTypes.length, eventData == null ? 0 : eventData.length));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private ArrayList<Method> getAnnotatedMethodsRecursively(Class<?> klass) {
        if (klass == null || klass.equals(Class.class)) {
            this.annotatedMethodsByClass.put(klass, null);
            return null;
        }
        if (this.annotatedMethodsByClass.containsKey(klass)) {
            return this.annotatedMethodsByClass.get(klass);
        }
        ArrayList<Method> result = new ArrayList<Method>();
        Method[] methods = klass.getDeclaredMethods();
        if (methods == null) {
            this.annotatedMethodsByClass.put(klass, null);
            return null;
        }
        for (Method method : methods) {
            AEvent annotation = method.getAnnotation(AEvent.class);
            if (annotation == null) continue;
            method.setAccessible(true);
            result.add(method);
        }
        ArrayList<Method> methodsFromSuperClass = this.getAnnotatedMethodsRecursively(klass.getSuperclass());
        if (methodsFromSuperClass != null) {
            result.addAll(methodsFromSuperClass);
        }
        this.annotatedMethodsByClass.put(klass, result);
        return result;
    }
}

