/*
 * Decompiled with CFR 0.152.
 */
package net.eunjae.android.aevent.event;

import android.os.Handler;
import net.eunjae.android.aevent.manager.AEventManager;
import net.eunjae.android.aevent.util.CompareUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event {
    private final String eventName;
    private Object[] eventData;
    private Class<?> eventTarget;
    private long timestamp;

    public Event(String eventName) {
        this.eventName = eventName;
        this.eventData = null;
        this.eventTarget = null;
        this.timestamp = System.currentTimeMillis();
    }

    public Event data(Object ... eventData) {
        this.eventData = eventData;
        return this;
    }

    public Event target(Class<?> eventTarget) {
        this.eventTarget = eventTarget;
        return this;
    }

    public void post() {
        AEventManager.getInstance().post(this);
    }

    public void postDelayed(long delay) {
        new Handler().postDelayed(new Runnable(){

            public void run() {
                Event.this.post();
            }
        }, delay);
    }

    public String _getEventName() {
        return this.eventName;
    }

    public Object[] _getEventData() {
        return this.eventData;
    }

    public Class<?> _getEventTarget() {
        return this.eventTarget;
    }

    public long _getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Event dest = (Event)o;
        if (CompareUtil.isDifferent(this._getEventName(), dest._getEventName())) {
            return false;
        }
        if (this._getEventData() != null && dest._getEventData() != null) {
            if (this._getEventData().length != dest._getEventData().length) {
                return false;
            }
            for (int i = 0; i < this._getEventData().length; ++i) {
                if (this._getEventData()[i].equals(dest._getEventData()[i])) continue;
                return false;
            }
            return true;
        }
        return this._getEventData() == null && dest._getEventData() == null;
    }
}

