/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.neobin.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import net.ericaro.neobin.NeoBin;
import net.ericaro.neobin.NeoBinException;
import net.ericaro.neobin.plugin.NeoBinDirectoryScanner;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class NeoBinMojo
extends AbstractMojo {
    private MavenProject project;
    private Collection nonGeneratedSourceRoots;
    private File sourceDirectory;
    private File outputDirectory;
    private int staleMillis;
    private boolean debug;
    private String[] includes;
    private String[] excludes;

    protected File getSourceDirectory() {
        return this.sourceDirectory;
    }

    protected String[] getIncludes() {
        if (this.includes != null) {
            return this.includes;
        }
        return new String[]{"**/*.xml", "**/*.dzl"};
    }

    protected String[] getExcludes() {
        return this.excludes;
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected int getStaleMillis() {
        return this.staleMillis;
    }

    protected File[] getCompileSourceRoots() {
        return new File[]{this.getOutputDirectory()};
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] neobins = this.scanForFiles();
        this.getLog().info((CharSequence)("starting NeoBin compilation from: " + this.getSourceDirectory()));
        if (neobins == null) {
            this.getLog().info((CharSequence)("Skipping non-existing neobin in directory: " + this.getSourceDirectory()));
            return;
        }
        if (neobins.length <= 0) {
            this.getLog().info((CharSequence)"Skipping - all neobin files are up to date");
        } else {
            this.determineNonGeneratedSourceRoots();
            this.processNeobin(neobins);
            this.getLog().info((CharSequence)("Processed " + neobins.length + " neobin " + (neobins.length != 1 ? "s" : "")));
        }
        File[] compileSourceRoots = this.getCompileSourceRoots();
        for (int i = 0; i < compileSourceRoots.length; ++i) {
            this.addSourceRoot(compileSourceRoots[i]);
        }
    }

    protected void processNeobin(File[] neobin) throws MojoExecutionException, MojoFailureException {
        try {
            NeoBin.generate(this.outputDirectory, neobin);
        }
        catch (NeoBinException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    private File[] scanForFiles() throws MojoExecutionException {
        if (!this.getSourceDirectory().isDirectory()) {
            return null;
        }
        this.getLog().debug((CharSequence)("Scanning for grammars: " + this.getSourceDirectory()));
        try {
            NeoBinDirectoryScanner scanner = new NeoBinDirectoryScanner();
            scanner.setSourceDirectory(this.getSourceDirectory());
            scanner.setIncludes(this.getIncludes());
            scanner.setExcludes(this.getExcludes());
            scanner.setOutputDirectory(this.getOutputDirectory());
            scanner.setStaleMillis(this.getStaleMillis());
            scanner.scan();
            File[] files = scanner.getIncludedFiles();
            this.getLog().debug((CharSequence)("Found files: " + Arrays.asList(files)));
            return files;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to scan for grammars: " + this.getSourceDirectory(), e);
        }
    }

    private void determineNonGeneratedSourceRoots() throws MojoExecutionException {
        this.nonGeneratedSourceRoots = new LinkedHashSet();
        try {
            String targetPrefix = new File(this.project.getBuild().getDirectory()).getCanonicalPath() + File.separator;
            List sourceRoots = this.project.getCompileSourceRoots();
            Iterator it = sourceRoots.iterator();
            while (it.hasNext()) {
                String sourcePath;
                File sourceRoot = new File(it.next().toString());
                if (!sourceRoot.isAbsolute()) {
                    sourceRoot = new File(this.project.getBasedir(), sourceRoot.getPath());
                }
                if (!(sourcePath = sourceRoot.getCanonicalPath()).startsWith(targetPrefix)) {
                    this.nonGeneratedSourceRoots.add(sourceRoot);
                    this.getLog().debug((CharSequence)("Non-generated compile source root: " + sourceRoot));
                    continue;
                }
                this.getLog().debug((CharSequence)("Generated compile source root: " + sourceRoot));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to determine non-generated source roots", (Exception)e);
        }
    }

    protected boolean isSourceRoot(File directory) {
        return this.nonGeneratedSourceRoots.contains(directory);
    }

    private void addSourceRoot(File directory) {
        if (this.project != null) {
            this.getLog().debug((CharSequence)("Adding compile source root: " + directory));
            this.project.addCompileSourceRoot(directory.getAbsolutePath());
        }
    }
}

