/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.neobin.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.DirectoryScanner;

class NeoBinDirectoryScanner {
    private DirectoryScanner scanner = new DirectoryScanner();
    private File outputDirectory;
    private int staleMillis;
    private List includedGrammars;

    public NeoBinDirectoryScanner() {
        this.scanner.setFollowSymlinks(true);
        this.includedGrammars = new ArrayList();
    }

    public void setSourceDirectory(File directory) {
        if (!directory.isAbsolute()) {
            throw new IllegalArgumentException("source directory is not absolute: " + directory);
        }
        this.scanner.setBasedir(directory);
    }

    public void setIncludes(String[] includes) {
        this.scanner.setIncludes(includes);
    }

    public void setExcludes(String[] excludes) {
        this.scanner.setExcludes(excludes);
        this.scanner.addDefaultExcludes();
    }

    public void setOutputDirectory(File directory) {
        if (directory != null && !directory.isAbsolute()) {
            throw new IllegalArgumentException("output directory is not absolute: " + directory);
        }
        this.outputDirectory = directory;
    }

    public void setStaleMillis(int milliseconds) {
        this.staleMillis = milliseconds;
    }

    public void scan() throws IOException {
        this.includedGrammars.clear();
        this.scanner.scan();
        String[] files = this.scanner.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            String path = files[i];
            File sourceFile = new File(this.scanner.getBasedir(), path);
            this.includedGrammars.add(sourceFile);
        }
    }

    public File[] getIncludedFiles() {
        return this.includedGrammars.toArray(new File[this.includedGrammars.size()]);
    }
}

