/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.neobin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.ericaro.neobin.BinGrex;
import net.ericaro.neobin.BinaryFormat;
import net.ericaro.neobin.BinaryType;
import net.ericaro.neobin.PrimitiveType;
import net.ericaro.neobin.State;
import net.ericaro.neobin.Transition;
import net.ericaro.neobin.UndefinedTransitionException;
import net.ericaro.neobin.v1.DataType;
import net.ericaro.neobin.v1.ManyType;
import net.ericaro.neobin.v1.Neobin;
import net.ericaro.neogrex.RegExpGraphBuilder;
import net.ericaro.neogrex.RegExpReceiver;
import net.ericaro.parser.ParseException;
import net.ericaro.parser.RegExpParser;

public class BinaryFormatBuilder {
    private Neobin src;
    private BinGrex grex;

    private String buildType(DataType type) {
        switch (type) {
            case FLOAT: {
                return "float";
            }
            case STRING: {
                return "java.lang.String";
            }
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
        }
        return null;
    }

    private Transition buildTransition(Neobin.Transitions.Transition t) {
        return new Transition(t.getName(), this.buildBinaryTypes(t.getVar()), null);
    }

    private List<BinaryType> buildBinaryTypes(List<Neobin.Transitions.Transition.Var> var) {
        ArrayList<BinaryType> res = new ArrayList<BinaryType>();
        for (Neobin.Transitions.Transition.Var v : var) {
            boolean many = v.getMany().equals((Object)ManyType.MANY);
            PrimitiveType p = this.buildBinaryType(v);
            BinaryType bt = many ? p.getBuffer() : p.getType();
            res.add(new BinaryType(bt, v.getName()));
        }
        return res;
    }

    private PrimitiveType buildBinaryType(Neobin.Transitions.Transition.Var v) {
        switch (v.getType()) {
            case BYTE: {
                return PrimitiveType.BYTE;
            }
            case INT: {
                return PrimitiveType.INT;
            }
            case LONG: {
                return PrimitiveType.LONG;
            }
            case FLOAT: {
                return PrimitiveType.FLOAT;
            }
            case DOUBLE: {
                return PrimitiveType.DOUBLE;
            }
            case STRING: {
                return PrimitiveType.STRING;
            }
        }
        throw new IllegalArgumentException("unkown type");
    }

    private void buildGraph() {
        final HashMap<String, Transition> index = new HashMap<String, Transition>();
        for (Neobin.Transitions.Transition t : this.src.getTransitions().getTransition()) {
            index.put(t.getName(), this.buildTransition(t));
        }
        try {
            this.grex = (BinGrex)((Object)RegExpParser.parse((String)this.src.getExpression(), (RegExpReceiver)new RegExpGraphBuilder<BinGrex, State, Transition>(){

                public BinGrex terminal(String name) {
                    return new BinGrex((Transition)index.get(name), new State(), new State());
                }
            }));
        }
        catch (ParseException e) {
            throw new RuntimeException("failed to generate the Graph for expression " + this.src.getExpression(), e);
        }
        HashSet<String> gTransitions = new HashSet<String>();
        for (Transition t : this.grex.getTransitions()) {
            gTransitions.add(t.getMethod());
        }
        HashSet xTransitions = new HashSet(index.keySet());
        if (!xTransitions.containsAll(gTransitions)) {
            gTransitions.removeAll(xTransitions);
            throw new UndefinedTransitionException(gTransitions);
        }
        if (!gTransitions.containsAll(xTransitions)) {
            xTransitions.removeAll(gTransitions);
        }
        int i = 0;
        for (State state : this.grex.getStates()) {
            state.setName(this.src.getName() + ++i);
            state.setId(i);
        }
    }

    private void buildStateNames() {
        this.grex.getStartState().setName(this.src.getName());
        for (Neobin.States.State s : this.src.getStates().getState()) {
            this.getStateByPath(s.getPath()).setName(s.getValue());
        }
    }

    private State getStateByPath(String key) {
        String[] elements = key.split("\\.");
        State current = this.grex.getStartState();
        block0: for (String next : elements) {
            for (Transition t : this.grex.getOutEdges(current)) {
                if (!next.equals(t.getMethod())) continue;
                current = this.grex.getDest(t);
                continue block0;
            }
        }
        return current;
    }

    protected void buildConnectedGraph() {
        for (Transition t : this.grex.getTransitions()) {
            State s = this.grex.getSource(t);
            State dest = this.grex.getDest(t);
            s.getTransitions().add(t);
            t.setNextState(dest);
        }
        for (State state : this.grex.getStates()) {
            int i = 0;
            for (Transition t : state.getTransitions()) {
                t.setId(i++);
            }
        }
    }

    public BinaryFormat build(Neobin src) {
        this.src = src;
        this.buildGraph();
        this.buildStateNames();
        this.buildConnectedGraph();
        ArrayList<State> states = new ArrayList<State>();
        for (State s : this.grex.getStates()) {
            if (this.grex.getStartState() == s || s.isTerminal()) continue;
            states.add(s);
        }
        BinaryFormat bf = new BinaryFormat(src.getPackage(), this.grex.getStartState(), states, this.grex.getTransitions());
        return bf;
    }
}

