package net.ericaro.neobin;

import java.util.List;

public class Transition {

	String method;
	List<BinaryType> types;
	State nextState;
	int id;

	
	public Transition(Transition that) {
		super();
		this.method    = that.method;
		this.types     = that.types;
		this.nextState = that.nextState;
	}
	public Transition(String method, List<BinaryType> types, State nextState) {
		super();
		this.method = method;
		this.types = types;
		this.nextState = nextState;
	}

	@Override
	public String toString() {
		return "Transition [method=" + method + " ]";
	}

	public String getMethod() {
		return method;
	}

	public void setMethod(String method) {
		this.method = method;
	}

	public Iterable<BinaryType> getTypes() {
		return types;
	}


	public State getNextState() {
		return nextState;
	}

	public void setNextState(State nextState) {
		this.nextState = nextState;
	}
	

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	/** returns a clone of this transition
	 * 
	 * @return
	 */
	public Transition newInstance() {
		
		return new Transition(method, types, null);
	}

}
