package net.ericaro.neobin;

import java.util.ArrayList;
import java.util.List;

public class State {

	String name;
	int id = 0;
	List<Transition> transitions = new ArrayList<Transition>();
	
	public State() {
		
	}
	
	public void setName(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public List<Transition> getTransitions() {
		return transitions;
	}

	public String getInstanceName() {
		return "_"+name;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public boolean isChoice() {
		return transitions.size() > 1 ;
	}
	
	/** return THE transition when there is only one
	 * 
	 * @return
	 */
	public Transition getTransition() {
		return getTransitions().get(0);
	}
	
	/** A terminal state is a state that has no outputs
	 * 
	 * @return
	 */
	public boolean isTerminal() {
		return getTransitions().size() <= 0 ;
	}
	
}

