package net.ericaro.neobin;

import java.io.File;
import java.util.logging.Logger;

import net.ericaro.neobin.v1.Neobin;

public class NeoBin {

	static Logger LOG = Logger.getLogger("net.ericaro.neobin");
	
	public static void generate(File target, File... sources) throws NeoBinException{
		
		try {
			for(File f: sources) {
				LOG.info("Processing "+ f);
				BinaryFormat bf = new BinaryFormatBuilder().build( (Neobin) FileUtil.read(f) );
				BinGenerator.compile(bf, target);
				
			}
		} catch (Exception e) {
			throw new NeoBinException(e);
		}
		
		
		
	}

	
	
	
}
