package net.ericaro.neobin;

public class BinaryType {

	String javaName;
	String javaVar;
	String name;
	int width;
	boolean composite = false;
	BinaryType component = null;// null by default unless composite is true

	public BinaryType(BinaryType component) {
		this("java.nio." + component.getName() + "Buffer", component.getName() + "Buffer",component.getJavaVar() + "Buffer", -1);
		this.component = component;
		this.composite = true;

	}

	public BinaryType(String javaName, String name, String javaVar, int width) {
		super();
		this.javaName = javaName;
		this.name = name;
		this.width = width;
		this.javaVar = javaVar;
	}

	public BinaryType(BinaryType bt, String varName) {
		this.javaName   = bt.javaName;
		this.javaVar    = varName;
		this.name 	    = bt.name;
		this.width 		= bt.width;
		this.composite  = bt.composite;
		this.component  = bt.component;
	}

	public String getJavaName() {
		return javaName;
	}

	public String getName() {
		return name;
	}

	public int getWidth() {
		return width;
	}

	public boolean isComposite() {
		return composite;
	}

	public String getJavaVar() {
		return javaVar;
	}

	public BinaryType getComponent() {
		return component;
	}
	
	public boolean isByte() {
		return "byte".equals(javaName );
	}

}
