package net.ericaro.neobin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BinaryFormat {

	String packageName;
	List<State> states;
	List<Transition> transitions;
	private State	start;
	EnumSet<PrimitiveType> types = EnumSet.range(PrimitiveType.BYTE, PrimitiveType.DOUBLE);
	
	
	public BinaryFormat(String packageName, State start, Collection<State> states, Collection<Transition> transitions) {
		super();
		this.packageName = packageName;
		this.start = start;
		this.states = new ArrayList<State>(states);
		this.transitions = new ArrayList<Transition>(transitions);
	}

	public Iterable<State> getStates() {
		return states;
	}

	
	public Iterable<Transition> getTransitions() {
		return transitions;
	}

	public String getPackageName() {
		return packageName;
	}

	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}

	public State getStart() {
		return start;
	}

	public Iterable<Transition> getUniqueTransitions(){
		List<Transition> res = new ArrayList<Transition>();
		Set<String> names = new HashSet<String>();
		for(Transition t: transitions)
			if (names.add(t.getMethod()))
				res.add(t);
		return res;
	}

	public Set<PrimitiveType> getTypes() {
		return types;
	}
	
	
}
