package net.ericaro.neobin;

import java.util.Collection;

import edu.uci.ics.jung.graph.DirectedSparseMultigraph;

import net.ericaro.neogrex.Grex;

public class BinGrex extends Grex<State, Transition> {

	
	
	public BinGrex() {
		super();
	}

	public BinGrex(Transition t, State src, State target) {
		super(t, src, target);
	}

	@Override
	protected State newState() {
		return new State();
	}

	@Override
	protected Transition cloneTransition(Transition t) {
		return new Transition(t);
	}

	@Override
	protected BinGrex newInstance() {
		return new BinGrex();
	}

	public Collection<Transition> getTransitions() {
		return super.g.getEdges();
	}

	public Collection<State> getStates() {
		return g.getVertices();
	}

	public State getSource(Transition edge) {
		return g.getSource(edge);
	}

	public State getDest(Transition edge) {
		return g.getDest(edge);
	}

	public State getStartState() {
		return in;
	}
	
	public boolean isOutputState(State state) {
		return outs.contains(state);
	}
	
	public Collection<Transition> getOutEdges(State current) {
		return g.getOutEdges(current);
	}
	
	

}
