package net.ericaro.neobin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.logging.Logger;

import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;

public class BinGenerator {

	static Logger LOG = Logger.getLogger("net.ericaro.neobin");
	
	public static STGroup FILE_CHANNEL_READER = new STGroupFile("net/ericaro/neobin/FileChannelReader.stg");
	public static STGroup FILE_CHANNEL_WRITER= new STGroupFile("net/ericaro/neobin/FileChannelWriter.stg");
	public static STGroup BINARY_READER= new STGroupFile("net/ericaro/neobin/BinaryReader.stg");
	public static STGroup BINARY_WRITER= new STGroupFile("net/ericaro/neobin/BinaryWriter.stg");
	
	public static STGroup MAP_ADDR= new STGroupFile("net/ericaro/neobin/MapAddr.stg");
	private final File	targetDirectory;
	private final BinaryFormat	format;
	
	
	public BinGenerator(BinaryFormat format, File targetDirectory) {
		this.format = format;
		this.targetDirectory = targetDirectory;
		
	}
	
	
	
	public static void compile(BinaryFormat format, File targetDirectory) throws IOException {
		new BinGenerator(format, targetDirectory).compile() ;
//		FileChannel fc;
//		
//		generate(FILE_CHANNEL_READER.getInstanceOf("readerUnit"  ) , format, targetDirectory, "FileChannelReader");
//		generate(FILE_CHANNEL_READER.getInstanceOf("receiverUnit") , format, targetDirectory, "FileChannelReceiver");
//		generate(FILE_CHANNEL_WRITER.getInstanceOf("writerUnit"  ) , format, targetDirectory, "FileChannelWriter");
//		generate(MAP_ADDR.getInstanceOf("mapUnit"  ) , format, targetDirectory, "MapAddr");
//		
//		
//		
//		
//		generate(BINARY_READER.getInstanceOf("receiverUnit") , format, targetDirectory, "BinaryReceiver");
//		generate(BINARY_READER.getInstanceOf("readerUnit"  ) , format, targetDirectory, "BinaryReader");
//		generate(BINARY_WRITER.getInstanceOf("writerUnit"  ) , format, targetDirectory, "BinaryWriter");
//		
//		
		
	}

	public void compile() throws IOException {
		
		g("FileChannelReader"   );
		g("FileChannelReceiver" );
		g("FileChannelWriter"   );
		g("MapAddr"             );
		g("BinaryReceiver"      );
		g("BinaryReader"        );
		g("BinaryWriter"        );
	}
	
	private void g(String name) throws IOException {
		LOG.info("    generating "+name);
		ST unit = new STGroupFile("net/ericaro/neobin/"+name+".stg").getInstanceOf("FileUnit");
		assert unit != null :"unexpected null ST unit";
		unit.add("format", format);
		String content = unit.render();
		toDir(targetDirectory, format.packageName, name+".java", content); 
	}
	
	public static void toDir(File dir, String packageName, String filename, String content) throws IOException {
		File d = packageName == null ? dir : new File(dir, packageName.replace(
				'.', '/'));
		File file = new File(d, filename );
		file.getParentFile().mkdirs();
		OutputStreamWriter w = new OutputStreamWriter(
				new FileOutputStream(file));
		w.write(content);
		if (true)
			w.close();
		LOG.info("    generated "+file.getPath());
	}
	
	
}
