/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.llrp4j.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.enilink.llrp4j.net.ChangeRequest;
import net.enilink.llrp4j.net.IoHandler;

class NioClient
implements Runnable,
AutoCloseable {
    private InetAddress hostAddress;
    private int port;
    private Selector selector;
    private ByteBuffer readBuffer = ByteBuffer.allocate(8192);
    private List<ChangeRequest> pendingChanges = new LinkedList<ChangeRequest>();
    private final Queue<ByteBuffer> pendingData = new ConcurrentLinkedQueue<ByteBuffer>();
    private final IoHandler handler;
    private SocketChannel channel;

    public NioClient(InetAddress hostAddress, int port, IoHandler handler, int timeout) throws IOException {
        this.hostAddress = hostAddress;
        this.port = port;
        this.handler = handler;
        this.selector = this.initSelector();
        try {
            this.channel = this.initConnection(true, timeout);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ByteBuffer data) {
        List<ChangeRequest> list = this.pendingChanges;
        synchronized (list) {
            this.pendingChanges.add(new ChangeRequest(this.channel, 2, 4));
        }
        this.pendingData.add(data);
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.selector.isOpen()) {
            try {
                List<ChangeRequest> list = this.pendingChanges;
                synchronized (list) {
                    for (ChangeRequest change : this.pendingChanges) {
                        switch (change.type) {
                            case 2: {
                                SelectionKey key = change.socket.keyFor(this.selector);
                                if (key == null || !key.isValid()) break;
                                key.interestOps(change.ops);
                                break;
                            }
                            case 1: {
                                change.socket.register(this.selector, change.ops);
                            }
                        }
                    }
                    this.pendingChanges.clear();
                }
                this.selector.select();
                if (!this.selector.isOpen()) {
                    return;
                }
                Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                while (selectedKeys.hasNext()) {
                    SelectionKey key = selectedKeys.next();
                    selectedKeys.remove();
                    if (!key.isValid()) continue;
                    if (key.isConnectable()) {
                        this.finishConnection(key);
                        continue;
                    }
                    if (key.isReadable()) {
                        this.read(key);
                        continue;
                    }
                    if (!key.isWritable()) continue;
                    this.write(key);
                }
            }
            catch (Exception e) {
                this.handler.handleException("Error while processing network channel", e);
            }
        }
    }

    private void read(SelectionKey key) throws IOException {
        int numRead;
        SocketChannel socketChannel = (SocketChannel)key.channel();
        this.readBuffer.clear();
        try {
            numRead = socketChannel.read(this.readBuffer);
        }
        catch (IOException e) {
            key.cancel();
            socketChannel.close();
            return;
        }
        if (numRead == -1) {
            key.channel().close();
            key.cancel();
            return;
        }
        byte[] receivedData = new byte[numRead];
        System.arraycopy(this.readBuffer.array(), 0, receivedData, 0, numRead);
        this.handler.processData(socketChannel, receivedData);
    }

    private void write(SelectionKey key) throws IOException {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        while (!this.pendingData.isEmpty()) {
            ByteBuffer buf = this.pendingData.element();
            socketChannel.write(buf);
            if (buf.remaining() > 0) break;
            this.pendingData.remove();
        }
        if (this.pendingData.isEmpty()) {
            key.interestOps(1);
        }
    }

    private void finishConnection(SelectionKey key) throws IOException {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        try {
            socketChannel.finishConnect();
        }
        catch (IOException e) {
            key.cancel();
            return;
        }
        key.interestOps(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketChannel initConnection(boolean connectBlocking, int timeout) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        if (!connectBlocking) {
            socketChannel.configureBlocking(false);
        } else {
            socketChannel.socket().setSoTimeout(timeout);
        }
        try {
            socketChannel.connect(new InetSocketAddress(this.hostAddress, this.port));
        }
        catch (IOException e) {
            socketChannel.close();
            throw e;
        }
        if (connectBlocking) {
            socketChannel.socket().setSoTimeout(0);
            socketChannel.configureBlocking(false);
            socketChannel.register(this.selector, 8);
            List<ChangeRequest> list = this.pendingChanges;
            synchronized (list) {
                this.pendingChanges.add(new ChangeRequest(socketChannel, 2, 4));
            }
        }
        List<ChangeRequest> list = this.pendingChanges;
        synchronized (list) {
            this.pendingChanges.add(new ChangeRequest(socketChannel, 1, 8));
        }
        return socketChannel;
    }

    private Selector initSelector() throws IOException {
        return SelectorProvider.provider().openSelector();
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        this.selector.close();
    }
}

