/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.llrp4j.net;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.List;
import net.enilink.llrp4j.LlrpContext;
import net.enilink.llrp4j.net.ChangeRequest;
import net.enilink.llrp4j.net.IoHandler;
import net.enilink.llrp4j.net.IoSession;
import net.enilink.llrp4j.net.LlrpEndpoint;
import net.enilink.llrp4j.net.NioServer;
import net.enilink.llrp4j.types.LlrpMessage;
import org.llrp.enumerations.ConnectionAttemptStatusType;
import org.llrp.messages.READER_EVENT_NOTIFICATION;
import org.llrp.parameters.ConnectionAttemptEvent;
import org.llrp.parameters.UTCTimestamp;

public class LlrpServer
implements Closeable {
    private NioServer nioServer;
    private IoHandler handler;
    private volatile SocketChannel channel;

    public LlrpServer(LlrpContext context, String host, int port) throws IOException {
        this.handler = this.createHandler(context);
        this.nioServer = new NioServer(InetAddress.getByName(host), port, this.handler){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected SocketChannel acceptChannel(ServerSocketChannel serverSocketChannel) throws IOException {
                SocketChannel newChannel = super.acceptChannel(serverSocketChannel);
                READER_EVENT_NOTIFICATION evtNotification = new READER_EVENT_NOTIFICATION();
                evtNotification.readerEventNotificationData().timestamp(new UTCTimestamp().microseconds(BigInteger.valueOf(System.currentTimeMillis()).multiply(BigInteger.valueOf(1000L))));
                ConnectionAttemptEvent connectionAttemptEvent = evtNotification.readerEventNotificationData().connectionAttemptEvent();
                if (LlrpServer.this.channel == null) {
                    LlrpServer.this.channel = newChannel;
                    connectionAttemptEvent.status(ConnectionAttemptStatusType.Success);
                    this.send(newChannel, LlrpServer.this.handler.encodeMessage(evtNotification));
                } else {
                    connectionAttemptEvent.status(ConnectionAttemptStatusType.Failed_A_Client_Initiated_Connection_Already_Exists);
                    this.send(newChannel, LlrpServer.this.handler.encodeMessage(evtNotification));
                    List list = this.pendingChanges;
                    synchronized (list) {
                        this.pendingChanges.add(new ChangeRequest(newChannel, 3, 0));
                    }
                }
                return LlrpServer.this.channel;
            }
        };
        new Thread(this.nioServer).start();
    }

    private IoHandler createHandler(LlrpContext context) {
        IoSession ioSession = new IoSession(){

            @Override
            public void send(ByteBuffer data) {
                LlrpServer.this.nioServer.send(LlrpServer.this.channel, data);
            }
        };
        return new IoHandler(context, ioSession, true, false);
    }

    public static LlrpServer create(LlrpContext context, String host) throws IOException {
        return LlrpServer.create(context, host, 5084);
    }

    public static LlrpServer create(LlrpContext context, String host, int port) throws IOException {
        return new LlrpServer(context, host, port);
    }

    public void send(LlrpMessage message) {
        this.handler.send(message);
    }

    public LlrpMessage transact(LlrpMessage message, long timeout) throws InterruptedException {
        return this.handler.transact(message, timeout);
    }

    public LlrpMessage transact(LlrpMessage message) throws InterruptedException {
        return this.transact(message, 10000L);
    }

    public LlrpServer setEndpoint(LlrpEndpoint endpoint) {
        this.handler.setEndpoint(endpoint);
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.nioServer != null) {
            this.nioServer.close();
            this.nioServer = null;
        }
    }
}

