/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.llrp4j.generator;

import com.helger.jcodemodel.AbstractCodeWriter;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.EClassType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JAnnotationArrayMember;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JDocComment;
import com.helger.jcodemodel.JEnumConstant;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.JPrimitiveType;
import com.helger.jcodemodel.JSwitch;
import com.helger.jcodemodel.JVar;
import com.helger.jcodemodel.writer.FileCodeWriter;
import com.helger.jcodemodel.writer.OutputStreamCodeWriter;
import java.io.OutputStream;
import java.io.StringWriter;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.enilink.llrp4j.Module;
import net.enilink.llrp4j.annotations.AllowedIn;
import net.enilink.llrp4j.annotations.LlrpCustomMessageType;
import net.enilink.llrp4j.annotations.LlrpCustomParameterType;
import net.enilink.llrp4j.annotations.LlrpField;
import net.enilink.llrp4j.annotations.LlrpMessageType;
import net.enilink.llrp4j.annotations.LlrpNamespace;
import net.enilink.llrp4j.annotations.LlrpParam;
import net.enilink.llrp4j.annotations.LlrpParameterType;
import net.enilink.llrp4j.annotations.LlrpProperties;
import net.enilink.llrp4j.generator.Repeat;
import net.enilink.llrp4j.types.LlrpEnum;
import net.enilink.llrp4j.types.LlrpMessage;
import net.enilink.llrp4j.types.Types;
import org.llrp.ltk.schema.core.AllowedInParameterReference;
import org.llrp.ltk.schema.core.Annotation;
import org.llrp.ltk.schema.core.ChoiceDefinition;
import org.llrp.ltk.schema.core.ChoiceParameterReference;
import org.llrp.ltk.schema.core.ChoiceReference;
import org.llrp.ltk.schema.core.CustomChoiceDefinition;
import org.llrp.ltk.schema.core.CustomEnumerationDefinition;
import org.llrp.ltk.schema.core.CustomMessageDefinition;
import org.llrp.ltk.schema.core.CustomParameterDefinition;
import org.llrp.ltk.schema.core.Description;
import org.llrp.ltk.schema.core.Documentation;
import org.llrp.ltk.schema.core.EnumerationDefinition;
import org.llrp.ltk.schema.core.EnumerationEntryDefinition;
import org.llrp.ltk.schema.core.FieldDefinition;
import org.llrp.ltk.schema.core.LlrpDefinition;
import org.llrp.ltk.schema.core.MessageDefinition;
import org.llrp.ltk.schema.core.NamespaceDefinition;
import org.llrp.ltk.schema.core.ParameterDefinition;
import org.llrp.ltk.schema.core.ParameterReference;
import org.llrp.ltk.schema.core.ReservedDefinition;
import org.llrp.ltk.schema.core.VendorDefinition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Generator {
    protected String packagePrefix = "org.llrp.";
    protected JCodeModel codeModel = new JCodeModel();
    protected List<JCodeModel> searchModels;
    protected List<AllowedInInfo> allowedInRefs = new ArrayList<AllowedInInfo>();
    protected List<NamespaceDefinition> namespaces = new ArrayList<NamespaceDefinition>();
    protected TransformerFactory tf = TransformerFactory.newInstance();
    protected Transformer transformer;

    public Generator(List<JCodeModel> baseCodeModels) throws TransformerConfigurationException, ParserConfigurationException {
        this.searchModels = new ArrayList<JCodeModel>(baseCodeModels);
        this.searchModels.add(this.codeModel);
        this.transformer = this.tf.newTransformer();
        this.transformer.setOutputProperty("method", "html");
        this.transformer.setOutputProperty("encoding", "UTF-8");
        this.transformer.setOutputProperty("indent", "no");
    }

    public static void main(String[] args) throws Exception {
        ArrayList<Path> definitionFiles = new ArrayList<Path>();
        Path outputPath = null;
        for (String arg : args) {
            Path p = Paths.get(arg, new String[0]);
            if (Files.isRegularFile(p, new LinkOption[0])) {
                definitionFiles.add(p);
                continue;
            }
            if (!Files.isDirectory(p, new LinkOption[0])) continue;
            outputPath = p;
        }
        JAXBContext context = JAXBContext.newInstance((String)LlrpDefinition.class.getPackage().getName(), (ClassLoader)LlrpDefinition.class.getClassLoader());
        Unmarshaller unmarshaller = context.createUnmarshaller();
        ArrayList<JCodeModel> codeModels = new ArrayList<JCodeModel>();
        for (Path p : definitionFiles) {
            JAXBElement element = (JAXBElement)unmarshaller.unmarshal(p.toFile());
            LlrpDefinition definition = (LlrpDefinition)element.getValue();
            Generator generator = new Generator(codeModels);
            generator.processDefinition(definition);
            generator.generateCustomParameterAnnotations();
            generator.generateGettersAndSetters();
            generator.generateHashCodeAndEquals();
            generator.addNamespaces();
            generator.generateModules();
            if (outputPath != null) {
                generator.getCodeModel().build((AbstractCodeWriter)new FileCodeWriter(outputPath.toFile(), Charset.forName("UTF-8")));
            } else {
                generator.getCodeModel().build((AbstractCodeWriter)new OutputStreamCodeWriter((OutputStream)System.out, Charset.forName("UTF-8")));
            }
            codeModels.add(generator.codeModel);
        }
    }

    private void addNamespaces() throws Exception {
        String namespace = this.namespaces.isEmpty() ? "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0" : this.namespaces.get(0).getURI();
        Iterator it = this.codeModel.packages();
        while (it.hasNext()) {
            JPackage p = (JPackage)it.next();
            if (p.name().endsWith("modules") || p.name().endsWith("interfaces")) continue;
            for (JDefinedClass c : p.classes()) {
                c.annotate(LlrpNamespace.class).param("value", namespace);
            }
        }
    }

    private void generateModules() throws Exception {
        String moduleName = this.namespaces.isEmpty() ? "llrp" : this.namespaces.get(0).getPrefix();
        JDefinedClass moduleClass = this.codeModel._class(this.packagePrefix + ("llrp".equals(moduleName) ? "" : moduleName.toLowerCase() + ".") + "modules." + this.firstUpper(moduleName) + "Module");
        moduleClass._extends(Module.class);
        for (NamespaceDefinition nd : this.namespaces) {
            moduleClass.instanceInit().invoke("addNamespace").arg(nd.getPrefix().toLowerCase()).arg(nd.getURI());
        }
        Iterator it = this.codeModel.packages();
        while (it.hasNext()) {
            JPackage p = (JPackage)it.next();
            if (p.name().endsWith("modules") || p.name().endsWith("interfaces")) continue;
            for (JDefinedClass c : p.classes()) {
                moduleClass.instanceInit().invoke("addClass").arg((IJExpression)JExpr.dotclass((AbstractJClass)c));
            }
        }
    }

    public JCodeModel getCodeModel() {
        return this.codeModel;
    }

    public void generateCustomParameterAnnotations() {
        String[] searchPackages = new String[]{this.customPkg() + ".messages", this.customPkg() + ".parameters", this.customPkg() + ".interfaces", "messages", "parameters", "interfaces"};
        for (AllowedInInfo allowedInInfo : this.allowedInRefs) {
            JAnnotationArrayMember allowedInArray = allowedInInfo.parameterAnnotation.paramArray("allowedIn");
            for (AllowedInParameterReference allowedIn : allowedInInfo.allowedIn) {
                AbstractJClass targetClass = this.findClass(allowedIn.getType(), searchPackages);
                if (targetClass == null) continue;
                Repeat repeat = Repeat.parse(allowedIn.getRepeat());
                String name = allowedIn.getName();
                boolean multiple = repeat == Repeat.R0_TO_N || repeat == Repeat.R1_TO_N;
                boolean required = repeat == Repeat.R1 || repeat == Repeat.R1_TO_N;
                JAnnotationUse annotation = allowedInArray.annotate(AllowedIn.class);
                annotation.param("targetType", (AbstractJType)targetClass);
                if (multiple) {
                    annotation.param("multiple", multiple);
                }
                if (required) {
                    annotation.param("required", required);
                }
                if (name != null) {
                    annotation.param("name", name);
                }
                if (!targetClass.isInterface()) continue;
                allowedInInfo.parameterClass._implements(targetClass);
            }
        }
    }

    String customPkg() {
        return this.namespaces.isEmpty() ? "custom" : this.namespaces.get(0).getPrefix().toLowerCase();
    }

    AbstractJClass findClass(String name, String pkg, boolean custom) {
        if (custom) {
            return this.findClass(name, pkg, this.customPkg() + "." + pkg);
        }
        return this.findClass(name, pkg);
    }

    AbstractJClass findClass(String name, String ... packages) {
        String fqn;
        for (String suffix : packages) {
            fqn = this.packagePrefix + suffix + "." + name;
            for (JCodeModel cm : this.searchModels) {
                JDefinedClass _class = cm._getClass(fqn);
                if (_class == null) continue;
                return _class;
            }
        }
        for (String suffix : packages) {
            fqn = this.packagePrefix + suffix + "." + name;
            try {
                Class<?> c = this.getClass().getClassLoader().loadClass(fqn);
                return this.codeModel.ref(c);
            }
            catch (ClassNotFoundException e) {
            }
        }
        return null;
    }

    JDefinedClass getOrCreateClass(String suffix, String name, boolean custom, EClassType classType) {
        String pkg = this.packagePrefix;
        String fqn = pkg + suffix + "." + name;
        JDefinedClass _class = null;
        for (JCodeModel cm : this.searchModels) {
            _class = cm._getClass(fqn);
            if (_class == null && custom) {
                fqn = pkg + this.customPkg() + "." + suffix + "." + name;
                _class = cm._getClass(fqn);
            }
            if (_class == null) continue;
            return _class;
        }
        if (_class == null) {
            try {
                _class = this.codeModel._class(fqn, classType);
            }
            catch (JClassAlreadyExistsException e) {
                throw new RuntimeException(e);
            }
        }
        return _class;
    }

    JDefinedClass messageClass(String name, boolean custom) {
        return this.getOrCreateClass("messages", name, custom, EClassType.CLASS);
    }

    JDefinedClass enumClass(String name, boolean custom) {
        return this.getOrCreateClass("enumerations", name, custom, EClassType.ENUM);
    }

    AbstractJClass enumClassRef(String name, boolean custom) {
        AbstractJClass c = this.findClass(name, "enumerations", custom);
        return c != null ? c : this.enumClass(name, custom);
    }

    JDefinedClass parameterClass(String name, boolean custom) {
        return this.getOrCreateClass("parameters", name, custom, EClassType.CLASS);
    }

    AbstractJClass parameterClassRef(String name, boolean custom) {
        AbstractJClass c = this.findClass(name, "parameters", custom &= !"custom".equalsIgnoreCase(name));
        return c != null ? c : this.parameterClass(name, custom);
    }

    JDefinedClass interfaceClass(String name, boolean custom) {
        return this.getOrCreateClass("interfaces", name, custom, EClassType.INTERFACE);
    }

    AbstractJClass interfaceClassRef(String name, boolean custom) {
        AbstractJClass c = this.findClass(name, "interfaces", custom);
        return c != null ? c : this.interfaceClass(name, custom);
    }

    void addProperties(JDefinedClass _class, List<String> properties) {
        _class.annotate(LlrpProperties.class).paramArray("value", properties.toArray(new String[properties.size()]));
    }

    void processDefinition(LlrpDefinition definition) throws JClassAlreadyExistsException {
        String name;
        Object d;
        HashMap<String, Long> vendors = new HashMap<String, Long>();
        for (Object element : definition.getElements()) {
            if (element instanceof VendorDefinition) {
                d = (VendorDefinition)element;
                name = ((VendorDefinition)d).getName();
                long vendorID = ((VendorDefinition)d).getVendorID();
                vendors.put(name, vendorID);
                this.annotations(((VendorDefinition)d).getAnnotation());
                continue;
            }
            if (!(element instanceof NamespaceDefinition)) continue;
            this.namespaces.add((NamespaceDefinition)element);
        }
        for (Object element : definition.getElements()) {
            if (element instanceof MessageDefinition) {
                d = (MessageDefinition)element;
                name = ((MessageDefinition)d).getName();
                JDefinedClass _class = this.messageClass(name, false);
                _class._extends(LlrpMessage.class);
                int typeNum = ((MessageDefinition)d).getTypeNum();
                JAnnotationUse msgAnnotation = _class.annotate(LlrpMessageType.class).param("typeNum", typeNum);
                if (((MessageDefinition)d).getResponseType() != null) {
                    msgAnnotation.param("responseType", (AbstractJType)this.messageClass(((MessageDefinition)d).getResponseType(), false));
                }
                if (!((MessageDefinition)d).getAnnotation().isEmpty()) {
                    this.javadoc(_class.javadoc(), ((MessageDefinition)d).getAnnotation());
                }
                ArrayList<String> properties = new ArrayList<String>();
                properties.addAll(this.fields(_class, msgAnnotation, ((MessageDefinition)d).getFieldOrReserved(), false));
                properties.addAll(this.parameters(_class, ((MessageDefinition)d).getParameterOrChoice(), false));
                this.addProperties(_class, properties);
                continue;
            }
            if (element instanceof ParameterDefinition) {
                d = (ParameterDefinition)element;
                name = ((ParameterDefinition)d).getName();
                int typeNum = ((ParameterDefinition)d).getTypeNum();
                int propertyCount = ((ParameterDefinition)d).getParameterOrChoice().size();
                for (Object fieldOrReserved : ((ParameterDefinition)d).getFieldOrReserved()) {
                    if (!(fieldOrReserved instanceof FieldDefinition)) continue;
                    ++propertyCount;
                }
                if (propertyCount == 1) {
                    // empty if block
                }
                JDefinedClass _class = this.parameterClass(name, false);
                if (!((ParameterDefinition)d).getAnnotation().isEmpty()) {
                    this.javadoc(_class.javadoc(), ((ParameterDefinition)d).getAnnotation());
                }
                JAnnotationUse parameterAnnotation = _class.annotate(LlrpParameterType.class).param("typeNum", typeNum);
                ArrayList<String> properties = new ArrayList<String>();
                properties.addAll(this.fields(_class, parameterAnnotation, ((ParameterDefinition)d).getFieldOrReserved(), false));
                properties.addAll(this.parameters(_class, ((ParameterDefinition)d).getParameterOrChoice(), false));
                this.addProperties(_class, properties);
                continue;
            }
            if (element instanceof ChoiceDefinition) {
                d = (ChoiceDefinition)element;
                name = ((ChoiceDefinition)d).getName();
                JDefinedClass _class = this.interfaceClass(name, false);
                if (!((ChoiceDefinition)d).getAnnotation().isEmpty()) {
                    this.javadoc(_class.javadoc(), ((ChoiceDefinition)d).getAnnotation());
                }
                this.choiceParameters(_class, ((ChoiceDefinition)d).getParameter());
                continue;
            }
            if (element instanceof EnumerationDefinition) {
                d = (EnumerationDefinition)element;
                name = ((EnumerationDefinition)d).getName();
                JDefinedClass _class = this.enumClass(name, false);
                _class._implements(LlrpEnum.class);
                _class.field(12, (AbstractJType)JPrimitiveType.INT, "value");
                JMethod constructor = _class.constructor(4);
                JVar valueParam = constructor.param((AbstractJType)JPrimitiveType.INT, "value");
                constructor.body().assign((IJAssignmentTarget)JExpr.refthis((String)"value"), (IJExpression)valueParam);
                if (!((EnumerationDefinition)d).getAnnotation().isEmpty()) {
                    this.javadoc(_class.javadoc(), ((EnumerationDefinition)d).getAnnotation());
                }
                for (EnumerationEntryDefinition entry : ((EnumerationDefinition)d).getEntry()) {
                    String entryName = entry.getName();
                    BigInteger value = entry.getValue();
                    JEnumConstant enumConstant = _class.enumConstant(entryName).arg((IJExpression)JExpr.lit((int)value.intValue()));
                    if (entry.getAnnotation().isEmpty()) continue;
                    this.javadoc(enumConstant.javadoc(), entry.getAnnotation());
                }
                this.generateEnumFromValue(_class, ((EnumerationDefinition)d).getEntry());
                continue;
            }
            if (element instanceof CustomMessageDefinition) {
                d = (CustomMessageDefinition)element;
                name = ((CustomMessageDefinition)d).getName();
                int subType = ((CustomMessageDefinition)d).getSubtype();
                String vendor = ((CustomMessageDefinition)d).getVendor();
                Long vendorID = (Long)vendors.get(vendor);
                if (vendorID == null) {
                    throw new IllegalArgumentException("Vendor definition '" + vendor + "' is missing.");
                }
                JDefinedClass _class = this.messageClass(name, true);
                _class._extends(LlrpMessage.class);
                JAnnotationUse msgAnnotation = _class.annotate(LlrpCustomMessageType.class).param("vendor", vendorID.longValue()).param("subType", subType);
                if (((CustomMessageDefinition)d).getResponseType() != null) {
                    msgAnnotation.param("responseType", (AbstractJType)this.messageClass(((CustomMessageDefinition)d).getResponseType(), true));
                }
                if (!((CustomMessageDefinition)d).getAnnotation().isEmpty()) {
                    this.javadoc(_class.javadoc(), ((CustomMessageDefinition)d).getAnnotation());
                }
                ArrayList<String> properties = new ArrayList<String>();
                properties.addAll(this.fields(_class, msgAnnotation, ((CustomMessageDefinition)d).getFieldOrReserved(), true));
                properties.addAll(this.parameters(_class, ((CustomMessageDefinition)d).getParameterOrChoice(), true));
                this.addProperties(_class, properties);
                String responseType = ((CustomMessageDefinition)d).getResponseType();
                continue;
            }
            if (element instanceof CustomParameterDefinition) {
                d = (CustomParameterDefinition)element;
                name = ((CustomParameterDefinition)d).getName();
                long subType = ((CustomParameterDefinition)d).getSubtype();
                String vendor = ((CustomParameterDefinition)d).getVendor();
                Long vendorID = (Long)vendors.get(vendor);
                if (vendorID == null) {
                    throw new IllegalArgumentException("Vendor definition '" + vendor + "' is missing.");
                }
                String namespace = ((CustomParameterDefinition)d).getNamespace();
                JDefinedClass _class = this.parameterClass(name, true);
                _class._extends(this.parameterClassRef("Custom", false));
                if (!((CustomParameterDefinition)d).getAnnotation().isEmpty()) {
                    this.javadoc(_class.javadoc(), ((CustomParameterDefinition)d).getAnnotation());
                }
                JAnnotationUse parameterAnnotation = _class.annotate(LlrpCustomParameterType.class).param("vendor", vendorID.longValue()).param("subType", subType);
                ArrayList<String> properties = new ArrayList<String>();
                properties.addAll(this.fields(_class, parameterAnnotation, ((CustomParameterDefinition)d).getFieldOrReserved(), true));
                properties.addAll(this.parameters(_class, ((CustomParameterDefinition)d).getParameterOrChoice(), true));
                this.addProperties(_class, properties);
                if (((CustomParameterDefinition)d).getAllowedIn().isEmpty()) continue;
                this.allowedInRefs.add(new AllowedInInfo(_class, parameterAnnotation, ((CustomParameterDefinition)d).getAllowedIn()));
                continue;
            }
            if (element instanceof CustomChoiceDefinition) {
                d = (CustomChoiceDefinition)element;
                name = ((CustomChoiceDefinition)d).getName();
                String namespace = ((CustomChoiceDefinition)d).getNamespace();
                JDefinedClass _class = this.interfaceClass(name, true);
                if (!((CustomChoiceDefinition)d).getAnnotation().isEmpty()) {
                    this.javadoc(_class.javadoc(), ((CustomChoiceDefinition)d).getAnnotation());
                }
                this.choiceParameters(_class, ((CustomChoiceDefinition)d).getParameter());
                continue;
            }
            if (element instanceof CustomEnumerationDefinition) {
                d = (CustomEnumerationDefinition)element;
                name = ((CustomEnumerationDefinition)d).getName();
                String namespace = ((CustomEnumerationDefinition)d).getNamespace();
                JDefinedClass _class = this.enumClass(name, true);
                _class._implements(LlrpEnum.class);
                _class.field(12, (AbstractJType)JPrimitiveType.INT, "value");
                JMethod constructor = _class.constructor(4);
                JVar valueParam = constructor.param((AbstractJType)JPrimitiveType.INT, "value");
                constructor.body().assign((IJAssignmentTarget)JExpr.refthis((String)"value"), (IJExpression)valueParam);
                if (!((CustomEnumerationDefinition)d).getAnnotation().isEmpty()) {
                    this.javadoc(_class.javadoc(), ((CustomEnumerationDefinition)d).getAnnotation());
                }
                for (EnumerationEntryDefinition entry : ((CustomEnumerationDefinition)d).getEntry()) {
                    String entryName = entry.getName();
                    BigInteger value = entry.getValue();
                    JEnumConstant enumConstant = _class.enumConstant(entryName).arg((IJExpression)JExpr.lit((int)value.intValue()));
                    if (entry.getAnnotation().isEmpty()) continue;
                    this.javadoc(enumConstant.javadoc(), entry.getAnnotation());
                }
                this.generateEnumFromValue(_class, ((CustomEnumerationDefinition)d).getEntry());
                continue;
            }
            if (!(element instanceof Annotation)) continue;
            List<Object> content = ((Annotation)element).getDocumentationOrDescription();
            String source = ((Annotation)element).getSource();
        }
    }

    private void generateEnumFromValue(JDefinedClass _class, List<EnumerationEntryDefinition> entries) {
        JMethod fromValue = _class.method(17, (AbstractJType)_class, "fromValue");
        JVar valueParam = fromValue.param((AbstractJType)JPrimitiveType.INT, "value");
        JSwitch s = fromValue.body()._switch((IJExpression)valueParam);
        for (EnumerationEntryDefinition entry : entries) {
            String entryName = entry.getName();
            BigInteger value = entry.getValue();
            s._case((IJExpression)JExpr.lit((int)value.intValue())).body()._return((IJExpression)JExpr.enumConstantRef((AbstractJClass)_class, (String)entryName));
        }
        fromValue.body()._throw((IJExpression)JExpr._new((AbstractJType)this.codeModel._ref(IllegalArgumentException.class)));
    }

    public void generateGettersAndSetters() {
        ArrayList packages = new ArrayList();
        Iterator it = this.codeModel.packages();
        while (it.hasNext()) {
            packages.add(it.next());
        }
        for (JPackage p : packages) {
            for (JDefinedClass c : p.classes()) {
                this.gettersAndSetters(c);
            }
        }
    }

    public void generateHashCodeAndEquals() {
        Iterator it = this.codeModel.packages();
        while (it.hasNext()) {
            JPackage p = (JPackage)it.next();
            for (JDefinedClass c : p.classes()) {
                if (c.isInterface() || c.getClassType() == EClassType.ENUM) continue;
                this.hashCode(c);
                this.equals(c);
            }
        }
    }

    static void dropPrefixes(Node node) {
        if (node.getNodeType() == 1) {
            node.setPrefix(null);
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Generator.dropPrefixes(list.item(i));
        }
    }

    void javadoc(JDocComment javadoc, List<Annotation> annotations) {
        ArrayList<Object> html = new ArrayList<Object>();
        StringWriter sw = new StringWriter();
        for (Annotation annotation : annotations) {
            for (Object content : annotation.getDocumentationOrDescription()) {
                if (!(content instanceof Description)) continue;
                html.addAll(((Description)content).getContent());
            }
        }
        for (Annotation annotation : annotations) {
            for (Object content : annotation.getDocumentationOrDescription()) {
                if (!(content instanceof Documentation)) continue;
                html.addAll(((Documentation)content).getContent());
            }
        }
        if (!html.isEmpty()) {
            for (Annotation annotation : html) {
                if (annotation instanceof Element) {
                    Generator.dropPrefixes((Element)((Object)annotation));
                    try {
                        this.transformer.transform(new DOMSource((Element)((Object)annotation)), new StreamResult(sw));
                    }
                    catch (TransformerException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                sw.write(annotation.toString());
            }
            String withoutXmlns = sw.toString().replaceAll("xmlns.*?(\"|').*?(\"|')\\s*", "").replaceAll("\\s+>", ">").replaceAll("[ \t]+", " ").replaceAll("\n ", "\n").replaceAll("\n<a", "\n@see <a");
            javadoc.add((Object)withoutXmlns);
        }
    }

    void annotations(List<Annotation> annotations) {
    }

    List<String> fields(JDefinedClass _class, JAnnotationUse typeAnnotation, List<Object> fieldOrReserved, boolean custom) {
        ArrayList<String> fields = new ArrayList<String>();
        JAnnotationUse fieldAnnotation = null;
        int reservedBefore = 0;
        for (Object fr : fieldOrReserved) {
            if (fr instanceof FieldDefinition) {
                JFieldVar _field;
                FieldDefinition fd = (FieldDefinition)fr;
                String enumeration = fd.getEnumeration();
                String name = this.firstLower(fd.getName());
                if (enumeration != null) {
                    boolean isArray = fd.getType().name().endsWith("_V");
                    AbstractJClass enumType = this.enumClassRef(enumeration, custom);
                    if (isArray) {
                        enumType = this.codeModel.ref(List.class).narrow(enumType);
                    }
                    _field = _class.field(2, (AbstractJType)enumType, name);
                } else {
                    Class<?> javaType = Types.javaType(fd.getType());
                    _field = _class.field(2, javaType, name);
                }
                fieldAnnotation = _field.annotate(LlrpField.class);
                fieldAnnotation.param("type", (Enum)fd.getType());
                if (fd.getFormat() != null) {
                    fieldAnnotation.param("format", (Enum)fd.getFormat());
                }
                if (reservedBefore > 0) {
                    fieldAnnotation.param("reservedBefore", reservedBefore);
                    reservedBefore = 0;
                }
                fields.add(name);
                continue;
            }
            if (!(fr instanceof ReservedDefinition)) continue;
            ReservedDefinition rd = (ReservedDefinition)fr;
            if (fieldAnnotation != null) {
                fieldAnnotation.param("reservedAfter", rd.getBitCount());
                continue;
            }
            reservedBefore = rd.getBitCount();
        }
        if (reservedBefore > 0) {
            typeAnnotation.param("reserved", reservedBefore);
        }
        return fields;
    }

    String firstUpper(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    String firstLower(String str) {
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    String startLower(String str) {
        int i;
        StringBuilder sb = new StringBuilder(str.length());
        int length = str.length();
        for (i = 0; i < length && Character.isUpperCase(str.charAt(i)); ++i) {
            sb.append(Character.toLowerCase(str.charAt(i)));
        }
        if (i > 1 && i < length - 1) {
            sb.replace(i - 1, i, Character.toString(Character.toUpperCase(sb.charAt(i - 1))));
        }
        return sb.append(str.substring(i)).toString();
    }

    void gettersAndSetters(JDefinedClass _class) {
        for (Map.Entry entry : _class.fields().entrySet()) {
            JFieldVar field = (JFieldVar)entry.getValue();
            AbstractJType type = field.type();
            if ((field.mods().getValue() & 8) == 0) {
                JMethod setter = _class.method(1, (AbstractJType)_class, this.startLower(this.firstUpper(field.name())));
                JVar value = setter.param(type, field.name());
                setter.body().assign((IJAssignmentTarget)JExpr.refthis((JVar)field), (IJExpression)value);
                setter.body()._return((IJExpression)JExpr._this());
            }
            boolean isList = type.isReference() && this.codeModel._ref(List.class).isAssignableFrom(type);
            boolean createIfNull = type.isReference() && (isList || !((AbstractJClass)type).isInterface()) && !type.isArray() && !this.codeModel._ref(Number.class).isAssignableFrom(type) && !type.fullName().contains("enumeration");
            JMethod builder = _class.method(1, type, this.startLower(this.firstUpper(field.name())));
            if (createIfNull) {
                JInvocation newInstance;
                if (isList) {
                    List typeParams = ((AbstractJClass)type).getTypeParameters();
                    AbstractJClass listType = this.codeModel.ref(ArrayList.class);
                    if (!typeParams.isEmpty()) {
                        listType = listType.narrow((AbstractJClass)typeParams.get(0));
                    }
                    newInstance = JExpr._new((AbstractJClass)listType);
                } else {
                    newInstance = JExpr._new((AbstractJType)type);
                }
                builder.body()._if((IJExpression)JExpr.ref((JVar)field).eqNull())._then().assign((IJAssignmentTarget)JExpr.ref((JVar)field), (IJExpression)newInstance);
                JMethod getter = _class.method(1, type, "get" + this.firstUpper(field.name()));
                getter.body()._return((IJExpression)JExpr.ref((JVar)field));
            }
            builder.body()._return((IJExpression)JExpr.ref((JVar)field));
        }
    }

    void equals(JDefinedClass _class) {
        JMethod equals = _class.method(1, (AbstractJType)JPrimitiveType.BOOLEAN, "equals");
        JVar obj = equals.param((AbstractJType)this.codeModel.ref(Object.class), "obj");
        JBlock body = equals.body();
        body._if((IJExpression)obj.eqNull())._then()._return((IJExpression)JExpr.lit((boolean)false));
        body._if((IJExpression)obj.invoke("getClass").ne((IJExpression)JExpr.invoke((String)"getClass")))._then()._return((IJExpression)JExpr.lit((boolean)false));
        if (!_class.fields().isEmpty()) {
            JVar o = body.decl((AbstractJType)_class, "other");
            body.assign((IJAssignmentTarget)o, (IJExpression)JExpr.cast((AbstractJType)_class, (IJExpression)obj));
            for (Map.Entry entry : _class.fields().entrySet()) {
                JFieldVar field = (JFieldVar)entry.getValue();
                JInvocation eq = (field.type().isArray() ? this.codeModel.ref(Arrays.class) : this.codeModel.ref(Objects.class)).staticInvoke("equals");
                eq.arg((IJExpression)JExpr.refthis((JVar)field)).arg((IJExpression)o.ref((JVar)field));
                JBlock then = body._if(eq.not())._then();
                then._return((IJExpression)JExpr.lit((boolean)false));
            }
        }
        body._return((IJExpression)JExpr.lit((boolean)true));
    }

    void hashCode(JDefinedClass _class) {
        JMethod hashCode = _class.method(1, (AbstractJType)JPrimitiveType.INT, "hashCode");
        JInvocation hash = this.codeModel.ref(Objects.class).staticInvoke("hash");
        hashCode.body()._return((IJExpression)hash);
        for (Map.Entry entry : _class.fields().entrySet()) {
            JFieldVar field = (JFieldVar)entry.getValue();
            hash.arg((IJExpression)JExpr.refthis((JVar)field));
        }
    }

    List<String> parameters(JDefinedClass _class, List<Object> parameterOrChoice, boolean custom) {
        if (parameterOrChoice.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> parameters = new ArrayList<String>();
        for (Object pc : parameterOrChoice) {
            List<Annotation> annotations;
            AbstractJClass typeClass;
            String type;
            String name;
            String repeatExpr;
            if (pc instanceof ParameterReference) {
                ParameterReference pr = (ParameterReference)pc;
                repeatExpr = pr.getRepeat();
                name = pr.getName();
                type = pr.getType();
                typeClass = this.parameterClassRef(type, custom);
                annotations = pr.getAnnotation();
            } else {
                ChoiceReference cr = (ChoiceReference)pc;
                repeatExpr = cr.getRepeat();
                name = cr.getName();
                type = cr.getType();
                typeClass = this.interfaceClassRef(type, custom);
                annotations = cr.getAnnotation();
            }
            if (name == null || name.trim().length() == 0) {
                name = this.firstLower(type);
            }
            Repeat repeat = Repeat.parse(repeatExpr);
            JFieldVar field = this.parameter(_class, repeat, typeClass, name);
            if (!annotations.isEmpty()) {
                this.javadoc(field.javadoc(), annotations);
            }
            parameters.add(name);
        }
        return parameters;
    }

    JFieldVar parameter(JDefinedClass _class, Repeat repeat, AbstractJClass typeClass, String name) {
        boolean multiple = repeat == Repeat.R0_TO_N || repeat == Repeat.R1_TO_N;
        AbstractJClass fieldType = multiple ? this.codeModel.ref(List.class).narrow(typeClass) : typeClass;
        JFieldVar field = _class.field(2, (AbstractJType)fieldType, name);
        field.annotate(LlrpParam.class).param("required", repeat == Repeat.R1 || repeat == Repeat.R1_TO_N);
        return field;
    }

    void choiceParameters(JDefinedClass choiceInterface, List<ChoiceParameterReference> parameters) {
        for (ChoiceParameterReference ref : parameters) {
            String type = ref.getType();
            if ("Custom".equals(type)) continue;
            this.parameterClass(type, false)._implements((AbstractJClass)choiceInterface);
        }
    }

    static class AllowedInInfo {
        final JDefinedClass parameterClass;
        final JAnnotationUse parameterAnnotation;
        final List<AllowedInParameterReference> allowedIn;

        public AllowedInInfo(JDefinedClass parameterClass, JAnnotationUse parameterAnnotation, List<AllowedInParameterReference> allowedIn) {
            this.parameterClass = parameterClass;
            this.parameterAnnotation = parameterAnnotation;
            this.allowedIn = allowedIn;
        }
    }
}

