/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.llrp4j;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.enilink.llrp4j.EncodingUtil;
import net.enilink.llrp4j.LlrpContext;
import net.enilink.llrp4j.LlrpException;
import net.enilink.llrp4j.annotations.LlrpField;
import net.enilink.llrp4j.impl.BaseType;
import net.enilink.llrp4j.impl.Property;
import net.enilink.llrp4j.types.LlrpEnum;
import net.enilink.llrp4j.types.LlrpMessage;
import net.enilink.llrp4j.types.XmlTypes;
import net.enilink.llrp4j.xml.IndentingXMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlEncoder {
    static final Logger logger = LoggerFactory.getLogger(XmlEncoder.class);
    protected LlrpContext context;
    protected final boolean indent;
    int depth = 0;

    public XmlEncoder(LlrpContext context, boolean indent) {
        this.context = context;
        this.indent = indent;
    }

    protected String localName(Class<?> c) {
        return c.getSimpleName();
    }

    protected void setNamespaces(XMLStreamWriter writer) throws XMLStreamException {
        writer.setDefaultNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        for (Map.Entry<String, String> nsdecl : this.context.getNamespaces().entrySet()) {
            if ("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0".equals(nsdecl.getValue())) continue;
            writer.setPrefix(nsdecl.getKey(), nsdecl.getValue());
        }
    }

    protected void writeNamespaces(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeDefaultNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        for (Map.Entry<String, String> nsdecl : this.context.getNamespaces().entrySet()) {
            if ("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0".equals(nsdecl.getValue())) continue;
            writer.writeNamespace(nsdecl.getKey(), nsdecl.getValue());
        }
    }

    protected XMLStreamWriter indentingWriter(XMLStreamWriter writer) {
        if (this.indent) {
            return new IndentingXMLStreamWriter(writer);
        }
        return writer;
    }

    public void encodeMessage(LlrpMessage message, XMLStreamWriter writer) throws Exception {
        writer = this.indentingWriter(writer);
        writer.writeStartDocument("1.0");
        this.setNamespaces(writer);
        Class<?> c = message.getClass();
        String ns = this.context.xmlNamespace(c);
        writer.writeStartElement(ns, this.localName(c));
        this.writeNamespaces(writer);
        BaseType messageType = this.context.messageType(message.getClass());
        if (messageType == null) {
            messageType = this.context.customMessageType(message.getClass());
        }
        this.encodeProperties(message, messageType.properties(), writer);
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    public void encodeParameter(Object parameter, XMLStreamWriter writer) throws Exception {
        writer = this.indentingWriter(writer);
        writer.writeStartDocument("1.0");
        this.setNamespaces(writer);
        this.encodeParameterInternal(parameter, writer, true);
    }

    private void encodeProperties(Object o, Property[] properties, XMLStreamWriter writer) throws Exception {
        String namespace = this.context.xmlNamespace(o.getClass());
        for (Property property : properties) {
            boolean empty;
            Object fieldValue = property.field.get(o);
            boolean list = List.class.isAssignableFrom(property.field.getType());
            boolean bl = empty = fieldValue == null || list && ((List)fieldValue).isEmpty();
            if (empty && property.required) {
                throw new LlrpException("Missing required " + (property.isField ? "field" : "parameter") + "' " + property.field.getName() + "' in " + (LlrpMessage.class.isAssignableFrom(o.getClass()) ? "message" : "parameter") + " of type '" + o.getClass().getSimpleName() + "'");
            }
            if (empty) continue;
            if (logger.isDebugEnabled()) {
                logger.debug(EncodingUtil.indent(this.depth, "encode " + property.field));
                ++this.depth;
            }
            if (property.isField) {
                this.encodeField(property.field, fieldValue, namespace, writer);
            } else {
                this.encodeParameterInternal(fieldValue, writer, false);
            }
            if (!logger.isDebugEnabled()) continue;
            --this.depth;
            logger.debug(EncodingUtil.indent(this.depth, "encoded " + property.field));
        }
    }

    private String enumToString(Object value) {
        if (value instanceof List) {
            StringBuilder sb = new StringBuilder();
            Iterator it = ((List)value).iterator();
            while (it.hasNext()) {
                LlrpEnum element = (LlrpEnum)it.next();
                sb.append(element.name());
                if (!it.hasNext()) continue;
                sb.append(" ");
            }
            return sb.toString();
        }
        return ((LlrpEnum)value).name();
    }

    private String encodeField(Field field, Object value, String namespace, XMLStreamWriter writer) throws Exception {
        LlrpField annotation = field.getAnnotation(LlrpField.class);
        if (value instanceof LlrpEnum || value instanceof List && LlrpEnum.class.isAssignableFrom(EncodingUtil.propertyType(field))) {
            value = this.enumToString(value);
        }
        String fieldName = EncodingUtil.firstUpper(field.getName());
        String fieldValue = XmlTypes.toString(value, annotation.format());
        if (writer != null) {
            writer.writeStartElement(namespace, fieldName);
            writer.writeCharacters(fieldValue);
            writer.writeEndElement();
        }
        return fieldValue;
    }

    protected void encodeParameterInternal(Object parameter, XMLStreamWriter writer, boolean writeNamespaces) throws Exception {
        boolean isList = parameter instanceof List;
        List<Object> elements = isList ? (List<Object>)parameter : Arrays.asList(parameter);
        for (Object e : elements) {
            Annotation parameterType;
            int typeNum;
            writer.writeStartElement(this.context.xmlNamespace(e.getClass()), this.localName(e.getClass()));
            if (writeNamespaces) {
                this.writeNamespaces(writer);
            }
            if ((typeNum = EncodingUtil.typeNum(parameterType = EncodingUtil.parameterType(e.getClass()))) < 128) {
                this.encodeTVParameter(parameterType, e, writer);
            } else {
                this.encodeTLVParameter(parameterType, e, writer);
            }
            writer.writeEndElement();
        }
    }

    private void encodeTVParameter(Annotation parameterType, Object parameter, XMLStreamWriter writer) throws Exception {
        Property[] properties = EncodingUtil.properties(parameterType, this.context);
        boolean inlineField = properties.length == 1;
        String namespace = this.context.xmlNamespace(parameter.getClass());
        for (Property property : EncodingUtil.properties(parameterType, this.context)) {
            Object fieldValue = property.field.get(parameter);
            this.encodeField(property.field, fieldValue, namespace, inlineField ? null : writer);
        }
    }

    private void encodeTLVParameter(Annotation parameterType, Object parameter, XMLStreamWriter writer) throws Exception {
        this.encodeProperties(parameter, EncodingUtil.properties(parameterType, this.context), writer);
    }
}

