/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.llrp4j;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import net.enilink.llrp4j.EncodingUtil;
import net.enilink.llrp4j.LlrpContext;
import net.enilink.llrp4j.annotations.LlrpField;
import net.enilink.llrp4j.impl.BaseType;
import net.enilink.llrp4j.impl.Property;
import net.enilink.llrp4j.types.LlrpEnum;
import net.enilink.llrp4j.types.LlrpMessage;
import net.enilink.llrp4j.types.XmlTypes;
import net.enilink.llrp4j.xml.AbstractXMLParser;
import net.enilink.llrp4j.xml.ParseException;
import org.llrp.ltk.schema.core.FieldType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlDecoder {
    static final Logger logger = LoggerFactory.getLogger(XmlDecoder.class);
    LlrpContext context;

    public XmlDecoder(LlrpContext context) {
        this.context = context;
    }

    private Class<?> propertyType(Field field) {
        Class propertyType = field.getType();
        if (List.class.isAssignableFrom(propertyType) && field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)field.getGenericType();
            propertyType = (Class)pType.getActualTypeArguments()[0];
        }
        return propertyType;
    }

    public LlrpMessage decodeMessage(XMLStreamReader reader) throws Exception {
        return new Parser(reader).parseMessage();
    }

    public Object decodeParameter(XMLStreamReader reader) throws Exception {
        return new Parser(reader).parseParameter();
    }

    class Parser
    extends AbstractXMLParser {
        int depth;

        Parser(XMLStreamReader reader) {
            super(reader);
            this.depth = 0;
        }

        LlrpMessage parseMessage() throws Exception {
            QName name = this.nextOrFail(new QName[0]);
            Class<?> typeClass = XmlDecoder.this.context.qnameToClass.get(name);
            if (typeClass == null) {
                throw new ParseException("Unknown element: " + name);
            }
            LlrpMessage message = (LlrpMessage)typeClass.newInstance();
            BaseType messageType = XmlDecoder.this.context.messageType(typeClass);
            this.parseProperties(message, messageType.properties());
            return message;
        }

        void parseProperties(Object o, Property[] properties) throws Exception {
            QName name = this.next(new QName[0]);
            for (int i = 0; i < properties.length; ++i) {
                Property property = properties[i];
                if (logger.isDebugEnabled()) {
                    logger.debug(EncodingUtil.indent(this.depth, "decode " + property.field));
                    ++this.depth;
                }
                boolean propertyWasRead = false;
                if (property.isField) {
                    String expectedName = EncodingUtil.firstUpper(property.field.getName());
                    if (name != null && name.getLocalPart().equals(expectedName)) {
                        Object fieldValue = this.parseField(property.field, null);
                        if (property.required && fieldValue == null) {
                            throw new ParseException("Missing content in element " + name);
                        }
                        property.field.set(o, fieldValue);
                        propertyWasRead = true;
                    } else if (property.required) {
                        this.unexpected(name);
                    }
                } else {
                    boolean isList = List.class.isAssignableFrom(property.field.getType());
                    ArrayList valueList = null;
                    boolean required = property.required;
                    Class expectedClass = XmlDecoder.this.propertyType(property.field);
                    ArrayList fieldValue = null;
                    while (true) {
                        Class<?> elementClass;
                        if ((elementClass = XmlDecoder.this.context.qnameToClass.get(name)) == null || !expectedClass.isAssignableFrom(elementClass)) {
                            propertyWasRead = false;
                            if (!required) break;
                            this.unexpected(name);
                            break;
                        }
                        propertyWasRead = true;
                        fieldValue = this.parseParameter(elementClass, isList, required);
                        if (required && (fieldValue == null || fieldValue instanceof List && ((List)fieldValue).isEmpty())) {
                            this.unexpected(name);
                        }
                        if (!isList) break;
                        if (valueList == null) {
                            valueList = new ArrayList();
                        }
                        if (fieldValue instanceof List) {
                            valueList.addAll(fieldValue);
                        } else {
                            valueList.add(fieldValue);
                        }
                        required = false;
                        this.end();
                        name = this.next(new QName[0]);
                    }
                    if (isList) {
                        fieldValue = valueList;
                    }
                    if (fieldValue != null) {
                        property.field.set(o, fieldValue);
                    }
                }
                if (logger.isDebugEnabled()) {
                    --this.depth;
                    logger.debug(EncodingUtil.indent(this.depth, "decoded " + property.field));
                }
                if (!propertyWasRead) continue;
                this.end();
                name = this.next(new QName[0]);
            }
            if (name != null) {
                this.useCurrentAsNext();
            }
        }

        private Object stringToEnum(Class<?> enumClass, boolean isList, String value) throws Exception {
            Method valueOf = enumClass.getDeclaredMethod("valueOf", String.class);
            if (isList) {
                String[] elements = value.split("\\s*,\\s*");
                ArrayList<Object> enumValues = new ArrayList<Object>(elements.length);
                for (int i = 0; i < elements.length; ++i) {
                    enumValues.add(valueOf.invoke(null, elements[i]));
                }
                return enumValues;
            }
            return valueOf.invoke(null, value);
        }

        private Object parseField(Field field, String value) throws Exception {
            LlrpField annotation = field.getAnnotation(LlrpField.class);
            FieldType type = annotation.type();
            if (value == null) {
                value = this.parseStringValue();
            }
            if (value.length() > 0) {
                Class elementType = XmlDecoder.this.propertyType(field);
                Object javaValue = LlrpEnum.class.isAssignableFrom(elementType) ? this.stringToEnum(elementType, List.class.isAssignableFrom(field.getType()), value) : XmlTypes.fromString(type, annotation.format(), value);
                return javaValue;
            }
            return null;
        }

        protected Object parseParameter() throws Exception {
            QName name = this.nextOrFail(new QName[0]);
            Class<?> elementClass = XmlDecoder.this.context.qnameToClass.get(name);
            return this.parseParameter(elementClass, false, false);
        }

        private Object parseParameter(Class<?> expectedType, boolean list, boolean required) throws Exception {
            Annotation parameterType = EncodingUtil.parameterType(expectedType);
            if (parameterType != null && EncodingUtil.typeNum(parameterType) < 128) {
                return this.parseTVParameter(parameterType, expectedType);
            }
            return this.parseTLVParameter(parameterType, expectedType, required);
        }

        private Object parseTVParameter(Annotation parameterType, Class<?> expectedType) throws Exception {
            Object parameter = expectedType.newInstance();
            this.parseProperties(parameter, EncodingUtil.properties(parameterType, XmlDecoder.this.context));
            return parameter;
        }

        private Object parseTLVParameter(Annotation parameterType, Class<?> expectedType, boolean required) throws Exception {
            Object parameter = expectedType.newInstance();
            this.parseProperties(parameter, EncodingUtil.properties(parameterType, XmlDecoder.this.context));
            return parameter;
        }
    }
}

