/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.llrp4j;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import net.enilink.llrp4j.EncodingUtil;
import net.enilink.llrp4j.LlrpContext;
import net.enilink.llrp4j.LlrpException;
import net.enilink.llrp4j.annotations.LlrpCustomParameterType;
import net.enilink.llrp4j.annotations.LlrpField;
import net.enilink.llrp4j.bitbuffer.BitBuffer;
import net.enilink.llrp4j.impl.BaseType;
import net.enilink.llrp4j.impl.CustomMessage;
import net.enilink.llrp4j.impl.Message;
import net.enilink.llrp4j.impl.Property;
import net.enilink.llrp4j.types.LlrpEnum;
import net.enilink.llrp4j.types.LlrpMessage;
import net.enilink.llrp4j.types.Types;
import org.llrp.ltk.schema.core.FieldType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryEncoder {
    static final Logger logger = LoggerFactory.getLogger(BinaryEncoder.class);
    protected LlrpContext context;
    int depth = 0;

    public BinaryEncoder(LlrpContext context) {
        this.context = context;
    }

    protected void encodeReserved(BaseType type, BitBuffer buffer) {
        int reserved = type.reservedBits;
        while (reserved-- > 0) {
            buffer.putBoolean(false);
        }
    }

    public void encodeMessage(LlrpMessage message, BitBuffer buffer) {
        BaseType messageType = this.context.messageType(message.getClass());
        if (messageType == null) {
            throw new LlrpException("Unsupported message type: " + message.getClass());
        }
        int typeNum = messageType instanceof CustomMessage ? 1023 : ((Message)messageType).type.typeNum();
        buffer.putInt(0, 3);
        buffer.putInt(1, 3);
        buffer.putInt(typeNum, 10);
        int messageLengthStart = buffer.position();
        buffer.putInt(0, 32);
        buffer.putLong(message.messageID(), 32);
        if (messageType instanceof CustomMessage) {
            buffer.putLong(((CustomMessage)messageType).type.vendor(), 32);
            buffer.putInt(((CustomMessage)messageType).type.subType(), 8);
        }
        this.encodeReserved(messageType, buffer);
        this.encodeProperties(message, messageType.properties(), buffer);
        int messageLength = (buffer.position() + 7) / 8;
        int mark = buffer.position();
        buffer.position(messageLengthStart);
        buffer.putInt(messageLength, 32);
        buffer.position(mark);
    }

    private void encodeProperties(Object o, Property[] properties, BitBuffer buffer) {
        try {
            for (Property property : properties) {
                boolean empty;
                Object fieldValue = property.field.get(o);
                boolean list = List.class.isAssignableFrom(property.field.getType());
                boolean bl = empty = fieldValue == null || list && ((List)fieldValue).isEmpty();
                if (empty && property.required) {
                    throw new LlrpException("Missing required " + (property.isField ? "field" : "parameter") + "' " + property.field.getName() + "' in " + (LlrpMessage.class.isAssignableFrom(o.getClass()) ? "message" : "parameter") + " of type '" + o.getClass().getSimpleName() + "'");
                }
                if (empty) continue;
                int pos = buffer.position();
                if (logger.isDebugEnabled()) {
                    logger.debug(EncodingUtil.indent(this.depth, "encode " + property.field + " pos=" + pos));
                    ++this.depth;
                }
                if (property.isField) {
                    this.encodeField(property.field, fieldValue, buffer);
                } else {
                    this.encodeParameter(fieldValue, buffer);
                }
                if (!logger.isDebugEnabled()) continue;
                --this.depth;
                logger.debug(EncodingUtil.indent(this.depth, "encoded " + property.field + " [" + pos + ", " + buffer.position() + "], length=" + (buffer.position() - pos)));
            }
        }
        catch (Exception e) {
            if (e instanceof LlrpException) {
                throw (LlrpException)e;
            }
            throw new LlrpException(e);
        }
    }

    private void encodeField(Field field, Object value, BitBuffer buffer) throws Exception {
        int i;
        LlrpField annotation = field.getAnnotation(LlrpField.class);
        FieldType type = annotation.type();
        for (i = 0; i < annotation.reservedBefore(); ++i) {
            buffer.putBoolean(false);
        }
        if (value instanceof LlrpEnum || value instanceof List && LlrpEnum.class.isAssignableFrom(EncodingUtil.propertyType(field))) {
            value = EncodingUtil.encodeEnum(type, value);
        }
        Types.encode(value, type, buffer);
        for (i = 0; i < annotation.reservedAfter(); ++i) {
            buffer.putBoolean(false);
        }
    }

    private void encodeParameter(Object parameter, BitBuffer buffer) throws Exception {
        List<Object> elements = parameter instanceof List ? (List<Object>)parameter : Arrays.asList(parameter);
        for (Object e : elements) {
            Annotation parameterType = EncodingUtil.parameterType(e.getClass());
            int typeNum = EncodingUtil.typeNum(parameterType);
            if (typeNum < 128) {
                this.encodeTVParameter(parameterType, e, buffer);
                continue;
            }
            this.encodeTLVParameter(parameterType, e, buffer);
        }
    }

    private void encodeTVParameter(Annotation parameterType, Object parameter, BitBuffer buffer) throws Exception {
        buffer.put(true);
        buffer.putInt(EncodingUtil.typeNum(parameterType), 7);
        for (Property property : EncodingUtil.properties(parameterType, this.context)) {
            Object fieldValue = property.field.get(parameter);
            this.encodeField(property.field, fieldValue, buffer);
        }
    }

    private void encodeTLVParameter(Annotation parameterType, Object parameter, BitBuffer buffer) throws Exception {
        int start = buffer.position();
        buffer.putInt(0, 6);
        buffer.putInt(EncodingUtil.typeNum(parameterType), 10);
        int lengthStart = buffer.position();
        buffer.putInt(0, 16);
        Property[] properties = EncodingUtil.properties(parameterType, this.context);
        if (EncodingUtil.isCustom(parameterType)) {
            LlrpCustomParameterType customType = (LlrpCustomParameterType)parameterType;
            buffer.putLong(customType.vendor(), 32);
            buffer.putLong(customType.subType(), 32);
        }
        this.encodeProperties(parameter, properties, buffer);
        int parameterLength = (buffer.position() - start + 7) / 8;
        int padding = parameterLength * 8 - buffer.position();
        while (padding-- > 0) {
            buffer.putBoolean(false);
        }
        int mark = buffer.position();
        buffer.position(lengthStart);
        buffer.putInt(parameterLength, 16);
        buffer.position(mark);
    }
}

