/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.llrp4j.xml;

import java.util.Arrays;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.enilink.llrp4j.xml.ParseException;

public abstract class AbstractXMLParser {
    private Stack<QName> context = new Stack();
    protected XMLStreamReader reader;
    private boolean useCurrentAsNext;

    public AbstractXMLParser(XMLStreamReader reader) {
        this.reader = reader;
    }

    protected QName[] combine(QName[] names1, QName ... names2) {
        QName[] combined = Arrays.copyOf(names1, names1.length + names2.length);
        System.arraycopy(names2, 0, combined, names1.length, names2.length);
        return combined;
    }

    protected void start(QName name) {
        this.context.push(name);
    }

    protected void useCurrentAsNext() {
        this.useCurrentAsNext = true;
    }

    protected void end() throws XMLStreamException, ParseException {
        if (this.reader.isEndElement()) {
            this.popContext();
            this.reader.next();
            this.useCurrentAsNext = true;
            return;
        }
        block4: while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    break block4;
                }
                case 2: {
                    this.popContext();
                    this.reader.next();
                    this.useCurrentAsNext = true;
                    return;
                }
                default: {
                    continue block4;
                }
            }
        }
        throw this.newError("Expected closing tag: " + this.context.peek());
    }

    protected void expected(QName ... names) throws ParseException {
        throw this.newError("Expected one of: " + this.toString(",\n", names));
    }

    protected String getAttribute(QName name) {
        String namespaceURI = name.getNamespaceURI();
        return this.reader.getAttributeValue("".equals(namespaceURI) ? null : namespaceURI, name.getLocalPart());
    }

    protected Boolean getBoolean(QName name) {
        String attribute = this.getAttribute(name);
        return attribute != null ? Boolean.valueOf(attribute) : null;
    }

    protected Integer getInteger(QName name) {
        String attribute = this.getAttribute(name);
        return attribute != null ? Integer.valueOf(attribute) : null;
    }

    protected String getString(QName name) {
        return this.getAttribute(name);
    }

    protected ParseException newError(String msg) throws ParseException {
        this.context.clear();
        return new ParseException(msg, this.reader.getLocation(), this.reader.hasName() ? this.reader.getName() : null);
    }

    protected QName next(QName ... names) throws XMLStreamException, ParseException {
        while (this.useCurrentAsNext || this.reader.hasNext()) {
            if (!this.useCurrentAsNext) {
                this.reader.next();
            } else {
                this.useCurrentAsNext = false;
            }
            switch (this.reader.getEventType()) {
                case 1: {
                    QName name = this.reader.getName();
                    if (names.length == 0) {
                        this.start(name);
                        return name;
                    }
                    for (QName expectedName : names) {
                        if (!expectedName.equals(name)) continue;
                        this.start(name);
                        return expectedName;
                    }
                }
                case 2: {
                    this.useCurrentAsNext = true;
                    return null;
                }
            }
        }
        return null;
    }

    protected QName nextOrFail(QName ... names) throws XMLStreamException, ParseException {
        QName next = this.next(names);
        if (next == null) {
            this.expected(names);
        }
        return next;
    }

    protected String parseStringValue() throws XMLStreamException, ParseException {
        StringBuilder sb = new StringBuilder();
        if (this.reader.isCharacters()) {
            sb.append(this.reader.getText());
        }
        block5: while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    this.useCurrentAsNext = true;
                    break block5;
                }
                case 2: {
                    break block5;
                }
                case 4: {
                    sb.append(this.reader.getText());
                }
                default: {
                    continue block5;
                }
            }
        }
        return sb.toString().trim();
    }

    private void popContext() throws ParseException {
        if (this.context.isEmpty()) {
            throw this.newError("Imbalance between opening and closing tags. Unexpected closing tag: " + this.reader.getName());
        }
        if (!this.context.peek().equals(this.reader.getName())) {
            throw this.newError("Unexpected closing tag: " + this.reader.getName() + ". Expected: " + this.context.peek());
        }
        this.context.pop();
    }

    protected void required(QName attributeName, Object value) throws ParseException {
        if (value == null || value instanceof String && ((String)value).length() == 0) {
            throw this.newError("Attribute " + attributeName + " is missing or has invalid value");
        }
    }

    protected String toString(String separator, Object ... values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            sb.append(values[i]);
            if (i >= values.length - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    protected void unexpected(QName name) throws ParseException {
        throw this.newError("Unexpected element " + name);
    }
}

