/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.llrp4j.types;

import java.util.BitSet;
import java.util.Objects;
import net.enilink.llrp4j.bitbuffer.BitBuffer;

public class BitList {
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private BitSet bits;
    private int length;

    public BitList() {
        this.bits = new BitSet(0);
        this.bits.clear(0);
        this.length = 0;
    }

    public BitList(byte[] bytes) {
        this.bits = new BitSet(bytes.length * 8);
        this.length = bytes.length * 8;
        BitBuffer buffer = BitBuffer.wrap(bytes);
        for (int i = 0; i < this.length; ++i) {
            this.bits.set(i, buffer.getBoolean());
        }
    }

    public BitList(String bitString) {
        this.bits = new BitSet(bitString.length());
        this.length = bitString.length();
        for (int i = 0; i < bitString.length(); ++i) {
            this.bits.set(i, bitString.charAt(i) != '0');
        }
    }

    public BitList(int n) {
        this.bits = new BitSet(n);
        this.length = n;
    }

    public void add(boolean bit) {
        this.bits.set(this.length, bit);
        ++this.length;
    }

    public void append(BitList other) {
        int position = this.length;
        for (int i = 0; i < other.length; ++i) {
            ++this.length;
            this.bits.set(position + i, other.get(i));
        }
    }

    public void clear(int position) {
        this.bits.clear(position);
    }

    public boolean get(int position) {
        return this.bits.get(position);
    }

    public int length() {
        return this.length;
    }

    public void pad(int count) {
        BitSet n = new BitSet(count);
        for (int i = 0; i < this.length; ++i) {
            n.set(count + i, this.bits.get(i));
        }
        this.bits = n;
        this.length += count;
    }

    public void set(int position) {
        this.set(position, true);
    }

    public void set(int position, boolean value) {
        if (position > this.length) {
            this.length = position + 1;
        }
        this.bits.set(position, value);
    }

    public BitList subList(Integer from, Integer subLength) {
        if (from < 0) {
            throw new IllegalArgumentException("illegal argument: trying to start sublist at negative position");
        }
        if (this.length < from + subLength) {
            throw new IllegalArgumentException("illegal argument: from plus sublist length longer than existing list");
        }
        BitList b = new BitList(subLength);
        for (int i = 0; i < subLength; ++i) {
            b.set(i, this.bits.get(from + i));
        }
        return b;
    }

    public byte[] toByteArray() {
        BitBuffer buffer = BitBuffer.allocateDynamic(this.length);
        for (int i = 0; i < this.length; ++i) {
            buffer.putBit(this.bits.get(i));
        }
        return buffer.asByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            sb.append(this.bits.get(i) ? (char)'1' : '0');
        }
        return sb.toString();
    }

    public String toHexString() {
        byte[] bytes = this.toByteArray();
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static BitList fromHexString(String hex) {
        if (hex.length() % 2 != 0) {
            hex = "0" + hex;
        }
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return new BitList(data);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        BitList other = (BitList)obj;
        if (this.length != other.length) {
            return false;
        }
        return Objects.equals(this.bits, other.bits);
    }

    public int hashCode() {
        return Objects.hash(this.length, this.bits);
    }
}

