/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.llrp4j.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.enilink.llrp4j.net.ChangeRequest;
import net.enilink.llrp4j.net.IoHandler;

class NioServer
implements Runnable {
    private InetAddress hostAddress;
    private int port;
    private ServerSocketChannel serverChannel;
    private Selector selector;
    private ByteBuffer readBuffer = ByteBuffer.allocate(8192);
    private final IoHandler handler;
    protected List<ChangeRequest> pendingChanges = new LinkedList<ChangeRequest>();
    protected Map<SocketChannel, List<ByteBuffer>> pendingData = new HashMap<SocketChannel, List<ByteBuffer>>();

    public NioServer(InetAddress hostAddress, int port, IoHandler handler) throws IOException {
        this.hostAddress = hostAddress;
        this.port = port;
        this.selector = this.initSelector();
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(SocketChannel socket, ByteBuffer data) {
        List<ChangeRequest> list = this.pendingChanges;
        synchronized (list) {
            this.pendingChanges.add(new ChangeRequest(socket, 2, 4));
            Map<SocketChannel, List<ByteBuffer>> map = this.pendingData;
            synchronized (map) {
                List<ByteBuffer> queue = this.pendingData.get(socket);
                if (queue == null) {
                    queue = new ArrayList<ByteBuffer>();
                    this.pendingData.put(socket, queue);
                }
                queue.add(data);
            }
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.selector.isOpen()) {
            try {
                List<ChangeRequest> list = this.pendingChanges;
                synchronized (list) {
                    for (ChangeRequest change : this.pendingChanges) {
                        switch (change.type) {
                            case 2: {
                                SelectionKey key = change.socket.keyFor(this.selector);
                                key.interestOps(change.ops);
                                break;
                            }
                            case 3: {
                                change.socket.close();
                            }
                        }
                    }
                    this.pendingChanges.clear();
                }
                this.selector.select();
                if (!this.selector.isOpen()) {
                    return;
                }
                Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                while (selectedKeys.hasNext()) {
                    SelectionKey key = selectedKeys.next();
                    selectedKeys.remove();
                    if (!key.isValid()) continue;
                    if (key.isAcceptable()) {
                        this.accept(key);
                        continue;
                    }
                    if (key.isReadable()) {
                        this.read(key);
                        continue;
                    }
                    if (!key.isWritable()) continue;
                    this.write(key);
                }
            }
            catch (Exception e) {
                this.handler.handleException("Error while processing network channel", e);
            }
        }
    }

    private void accept(SelectionKey key) throws IOException {
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
        SocketChannel socketChannel = this.acceptChannel(serverSocketChannel);
        socketChannel.configureBlocking(false);
        socketChannel.register(this.selector, 1);
    }

    protected SocketChannel acceptChannel(ServerSocketChannel serverSocketChannel) throws IOException {
        return serverSocketChannel.accept();
    }

    private void read(SelectionKey key) throws IOException {
        int numRead;
        SocketChannel socketChannel = (SocketChannel)key.channel();
        this.readBuffer.clear();
        try {
            numRead = socketChannel.read(this.readBuffer);
        }
        catch (IOException e) {
            key.cancel();
            socketChannel.close();
            return;
        }
        if (numRead == -1) {
            key.channel().close();
            key.cancel();
            return;
        }
        byte[] receivedData = new byte[numRead];
        System.arraycopy(this.readBuffer.array(), 0, receivedData, 0, numRead);
        this.handler.processData(socketChannel, receivedData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(SelectionKey key) throws IOException {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        Map<SocketChannel, List<ByteBuffer>> map = this.pendingData;
        synchronized (map) {
            List<ByteBuffer> queue = this.pendingData.get(socketChannel);
            while (!queue.isEmpty()) {
                ByteBuffer buf = queue.get(0);
                socketChannel.write(buf);
                if (buf.remaining() > 0) break;
                queue.remove(0);
            }
            if (queue.isEmpty()) {
                key.interestOps(1);
            }
        }
    }

    private Selector initSelector() throws IOException {
        AbstractSelector socketSelector = SelectorProvider.provider().openSelector();
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        InetSocketAddress isa = new InetSocketAddress(this.hostAddress, this.port);
        this.serverChannel.socket().bind(isa);
        this.serverChannel.register(socketSelector, 16);
        return socketSelector;
    }

    public void close() throws IOException {
        this.selector.close();
    }
}

