/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.llrp4j;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.enilink.llrp4j.EncodingUtil;
import net.enilink.llrp4j.LlrpContext;
import net.enilink.llrp4j.LlrpException;
import net.enilink.llrp4j.annotations.LlrpField;
import net.enilink.llrp4j.bitbuffer.BitBuffer;
import net.enilink.llrp4j.bitbuffer.SimpleBitBuffer;
import net.enilink.llrp4j.impl.BaseType;
import net.enilink.llrp4j.impl.CustomKey;
import net.enilink.llrp4j.impl.CustomParameter;
import net.enilink.llrp4j.impl.Parameter;
import net.enilink.llrp4j.impl.Property;
import net.enilink.llrp4j.types.LlrpEnum;
import net.enilink.llrp4j.types.LlrpMessage;
import net.enilink.llrp4j.types.Types;
import org.llrp.ltk.schema.core.FieldType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryDecoder {
    static final Logger logger = LoggerFactory.getLogger(BinaryDecoder.class);
    static final int RESERVED_LENGTH = 3;
    static final int VERSION_LENGTH = 3;
    static final int TYPE_LENGTH = 10;
    LlrpContext context;
    int depth = 0;

    public BinaryDecoder(LlrpContext context) {
        this.context = context;
    }

    protected void decodeReserved(BaseType type, BitBuffer buffer) throws Exception {
        int reserved = type.reservedBits;
        while (reserved-- > 0) {
            buffer.getBoolean();
        }
    }

    public LlrpMessage decodeMessage(BitBuffer buffer) throws Exception {
        int subtype;
        long vendor;
        buffer.position(buffer.position() + 3);
        int version = buffer.getInt(3);
        int typeNum = buffer.getIntUnsigned(10);
        long length = buffer.getLongUnsigned(32);
        long messageID = buffer.getLongUnsigned(32);
        BaseType messageType = null;
        if (typeNum == 1023 && (messageType = (BaseType)this.context.customMessageTypes.get(new CustomKey(vendor = buffer.getLongUnsigned(32), subtype = buffer.getIntUnsigned(8)))) == null) {
            buffer.position(buffer.position() - 40);
        }
        if (messageType == null) {
            messageType = this.context.messageTypes.get(typeNum);
        }
        LlrpMessage message = (LlrpMessage)messageType.typeClass.newInstance();
        message.messageID(messageID);
        this.decodeReserved(messageType, buffer);
        this.decodeProperties(message, messageType.properties(), buffer);
        return message;
    }

    private void decodeProperties(Object o, Property[] properties, BitBuffer buffer) throws Exception {
        for (Property property : properties) {
            int pos = buffer.position();
            if (pos >= buffer.size()) break;
            if (logger.isDebugEnabled()) {
                logger.debug(EncodingUtil.indent(this.depth, "decode " + property.field + " pos=" + (pos + ((SimpleBitBuffer)buffer).offset())));
                ++this.depth;
            }
            Object fieldValue = property.isField ? this.decodeField(property.field, buffer) : this.decodeParameter(EncodingUtil.propertyType(property.field), List.class.isAssignableFrom(property.field.getType()), property.required, buffer);
            property.field.set(o, fieldValue);
            if (!logger.isDebugEnabled()) continue;
            --this.depth;
            logger.debug(EncodingUtil.indent(this.depth, "decoded " + property.field + " length=" + (buffer.position() - pos)));
        }
    }

    private Object decodeField(Field field, BitBuffer buffer) throws Exception {
        LlrpField annotation = field.getAnnotation(LlrpField.class);
        FieldType type = annotation.type();
        for (int i = 0; i < annotation.reservedBefore(); ++i) {
            buffer.getBoolean();
        }
        Object value = Types.decode(type, buffer);
        Class<?> elementType = EncodingUtil.propertyType(field);
        if (LlrpEnum.class.isAssignableFrom(elementType)) {
            value = EncodingUtil.decodeEnum(elementType, value);
        }
        for (int i = 0; i < annotation.reservedAfter(); ++i) {
            buffer.getBoolean();
        }
        return value;
    }

    private Object decodeParameter(Class<?> expectedType, boolean list, boolean required, BitBuffer buffer) throws Exception {
        int bufferSize = buffer.size();
        Object parameter = null;
        ArrayList<Object> elements = null;
        int count = 0;
        while (buffer.position() < bufferSize) {
            boolean tvParameter = buffer.getBoolean();
            buffer.position(buffer.position() - 1);
            parameter = tvParameter ? this.decodeTVParameter(expectedType, buffer) : this.decodeTLVParameter(expectedType, buffer);
            if (parameter == null) {
                if (count != 0 || !required) break;
                throw new LlrpException("Missing required parameter of type '" + expectedType.getName() + "'.");
            }
            if (!list) break;
            if (elements == null) {
                elements = new ArrayList<Object>();
            }
            elements.add(parameter);
            ++count;
        }
        if (list) {
            return elements;
        }
        return parameter;
    }

    private Object decodeTVParameter(Class<?> expectedType, BitBuffer buffer) throws Exception {
        int start = buffer.position();
        buffer.getBoolean();
        int typeNum = buffer.getIntUnsigned(7);
        Parameter parameterType = this.context.parameterTypes.get(typeNum);
        if (parameterType == null) {
            throw new LlrpException("Unknown parameter with type=" + typeNum);
        }
        if (!expectedType.isAssignableFrom(parameterType.typeClass)) {
            buffer.position(start);
            return null;
        }
        Object parameter = parameterType.typeClass.newInstance();
        this.decodeProperties(parameter, EncodingUtil.properties(parameterType.type, this.context), buffer);
        return parameter;
    }

    private Object decodeTLVParameter(Class<?> expectedType, BitBuffer buffer) throws Exception {
        int start = buffer.position();
        buffer.position(start + 6);
        int typeNum = buffer.getIntUnsigned(10);
        Parameter p = this.context.parameterTypes.get(typeNum);
        if (p == null) {
            throw new LlrpException("Unknown parameter with type=" + typeNum);
        }
        Class typeClass = p.typeClass;
        Annotation parameterType = p.type;
        boolean isCustom = typeNum == 1023;
        int length = buffer.getIntUnsigned(16);
        Object parameter = null;
        if (isCustom) {
            long subtype;
            long vendor = buffer.getLongUnsigned(32);
            CustomParameter customParameter = this.context.customParameterTypes.get(new CustomKey(vendor, subtype = buffer.getLongUnsigned(32)));
            if (customParameter != null) {
                parameterType = customParameter.type;
                typeClass = customParameter.typeClass;
            } else {
                buffer.position(buffer.position() - 64);
            }
        }
        if (!expectedType.isAssignableFrom(typeClass)) {
            buffer.position(start);
            return null;
        }
        parameter = typeClass.newInstance();
        int pos = buffer.position();
        int paramContentLength = length * 8 - (pos - start);
        if (paramContentLength > 0) {
            this.decodeProperties(parameter, EncodingUtil.properties(parameterType, this.context), buffer.slice(pos, paramContentLength));
        }
        buffer.position(pos + paramContentLength);
        return parameter;
    }
}

