/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.llrp4j.types;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.enilink.llrp4j.bitbuffer.BitBuffer;
import net.enilink.llrp4j.types.BitList;
import org.llrp.ltk.schema.core.FieldType;

public class Types {
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS = new HashMap();

    public static void encode(Object value, FieldType fieldType, BitBuffer buffer) {
        switch (fieldType) {
            case U_1: {
                buffer.putBit((Boolean)value);
                return;
            }
            case U_2: {
                buffer.putInt(((Number)value).intValue(), 2);
                return;
            }
            case U_1_V: {
                Types.encodeBits((BitList)value, FieldType.U_1, buffer);
                return;
            }
            case U_8: {
                buffer.putInt(((Number)value).intValue(), 8);
                return;
            }
            case S_8: {
                buffer.putInt(((Number)value).intValue(), 8);
                return;
            }
            case U_8_V: {
                Types.encodeArray((int[])value, FieldType.U_8, buffer);
                return;
            }
            case S_8_V: {
                Types.encodeArray((int[])value, FieldType.S_8, buffer);
                return;
            }
            case UTF_8_V: {
                byte[] bytes = value.toString().getBytes(StandardCharsets.UTF_8);
                buffer.putInt(bytes.length, 16);
                buffer.put(bytes);
                return;
            }
            case U_16: {
                buffer.putInt(((Number)value).intValue(), 16);
                return;
            }
            case S_16: {
                buffer.putInt(((Number)value).intValue(), 16);
                return;
            }
            case U_16_V: {
                Types.encodeArray((int[])value, FieldType.U_16, buffer);
                return;
            }
            case S_16_V: {
                Types.encodeArray((int[])value, FieldType.S_16, buffer);
                return;
            }
            case U_32: {
                buffer.putLong(((Number)value).longValue(), 32);
                return;
            }
            case S_32: {
                buffer.putLong(((Number)value).longValue(), 32);
                return;
            }
            case U_32_V: {
                Types.encodeArray((long[])value, FieldType.S_32, buffer);
                return;
            }
            case S_32_V: {
                Types.encodeArray((int[])value, FieldType.S_32, buffer);
                return;
            }
            case U_64: {
                BigInteger l = (BigInteger)value;
                BigInteger mask = BigInteger.valueOf(0xFFFFFFFFL);
                buffer.putLong(l.shiftRight(32).and(mask).longValue(), 32);
                buffer.putLong(l.and(mask).longValue(), 32);
                return;
            }
            case S_64: {
                BigInteger l = (BigInteger)value;
                BigInteger mask = BigInteger.valueOf(0xFFFFFFFFL);
                buffer.putLong(l.shiftRight(32).and(mask).longValue(), 32);
                buffer.putLong(l.and(mask).longValue(), 32);
                return;
            }
            case U_64_V: {
                Types.encodeArray((BigInteger[])value, FieldType.U_64, buffer);
                return;
            }
            case S_64_V: {
                Types.encodeArray((BigInteger[])value, FieldType.S_64, buffer);
                return;
            }
            case U_96: {
                BigInteger l = (BigInteger)value;
                BigInteger mask = BigInteger.valueOf(0xFFFFFFFFL);
                buffer.putLong(l.shiftRight(64).and(mask).longValue(), 32);
                buffer.putLong(l.shiftRight(32).and(mask).longValue(), 32);
                buffer.putLong(l.and(mask).longValue(), 32);
                return;
            }
            case BYTES_TO_END: {
                buffer.put((byte[])value);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)fieldType));
    }

    private static void encodeBits(BitList bits, FieldType fieldType, BitBuffer buffer) {
        int length = bits.length();
        buffer.putInt(length, 16);
        for (int i = 0; i < length; ++i) {
            buffer.putBoolean(bits.get(i));
        }
        if (length % 8 != 0) {
            int padding = 8 - length % 8;
            while (padding-- > 0) {
                buffer.putBoolean(false);
            }
        }
    }

    private static void encodeArray(int[] elements, FieldType fieldType, BitBuffer buffer) {
        buffer.putInt(elements.length, 16);
        for (int i = 0; i < elements.length; ++i) {
            Types.encode(elements[i], fieldType, buffer);
        }
    }

    private static void encodeArray(long[] elements, FieldType fieldType, BitBuffer buffer) {
        buffer.putInt(elements.length, 16);
        for (int i = 0; i < elements.length; ++i) {
            Types.encode(elements[i], fieldType, buffer);
        }
    }

    private static void encodeArray(Object[] elements, FieldType fieldType, BitBuffer buffer) {
        buffer.putInt(elements.length, 16);
        for (int i = 0; i < elements.length; ++i) {
            Types.encode(elements[i], fieldType, buffer);
        }
    }

    public static Object decode(FieldType fieldType, BitBuffer buffer) {
        switch (fieldType) {
            case U_1: {
                return buffer.getBoolean();
            }
            case U_2: {
                return buffer.getIntUnsigned(2);
            }
            case U_1_V: {
                int length = buffer.getIntUnsigned(16);
                return Types.decodeBits(length, FieldType.U_1, buffer);
            }
            case U_8: {
                return buffer.getIntUnsigned(8);
            }
            case S_8: {
                return buffer.getInt(8);
            }
            case U_8_V: {
                return Types.decodeArray(new int[buffer.getIntUnsigned(16)], FieldType.U_8, buffer);
            }
            case S_8_V: {
                return Types.decodeArray(new int[buffer.getIntUnsigned(16)], FieldType.S_8, buffer);
            }
            case UTF_8_V: {
                int length = buffer.getIntUnsigned(16);
                return buffer.getString(length, StandardCharsets.UTF_8);
            }
            case U_16: {
                return buffer.getIntUnsigned(16);
            }
            case S_16: {
                return buffer.getInt(16);
            }
            case U_16_V: {
                return Types.decodeArray(new int[buffer.getIntUnsigned(16)], FieldType.U_16, buffer);
            }
            case S_16_V: {
                return Types.decodeArray(new int[buffer.getIntUnsigned(16)], FieldType.S_16, buffer);
            }
            case U_32: {
                return buffer.getLongUnsigned(32);
            }
            case S_32: {
                return buffer.getInt(32);
            }
            case U_32_V: {
                return Types.decodeArray(new long[buffer.getIntUnsigned(16)], FieldType.U_32, buffer);
            }
            case S_32_V: {
                return Types.decodeArray(new int[buffer.getIntUnsigned(16)], FieldType.S_32, buffer);
            }
            case U_64: {
                return BigInteger.valueOf(buffer.getLongUnsigned(32)).shiftLeft(32).add(BigInteger.valueOf(buffer.getLongUnsigned(32)));
            }
            case S_64: {
                return BigInteger.valueOf(buffer.getLongUnsigned(32)).shiftLeft(32).add(BigInteger.valueOf(buffer.getLongUnsigned(32)));
            }
            case U_64_V: {
                return Types.decodeArray(new BigInteger[buffer.getIntUnsigned(16)], FieldType.U_64, buffer);
            }
            case S_64_V: {
                return Types.decodeArray(new BigInteger[buffer.getIntUnsigned(16)], FieldType.S_64, buffer);
            }
            case U_96: {
                BigInteger first = BigInteger.valueOf(buffer.getLongUnsigned(32));
                BigInteger second = BigInteger.valueOf(buffer.getLongUnsigned(32));
                BigInteger third = BigInteger.valueOf(buffer.getLongUnsigned(32));
                return first.shiftLeft(32).add(second).shiftLeft(32).add(third);
            }
            case BYTES_TO_END: {
                int byteLength = (buffer.size() - buffer.position()) / 8;
                byte[] bytes = new byte[byteLength];
                buffer.get(bytes);
                return bytes;
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)fieldType));
    }

    private static BitList decodeBits(int length, FieldType fieldType, BitBuffer buffer) {
        BitList result = new BitList();
        for (int i = 0; i < length; ++i) {
            result.set(i, buffer.getBoolean());
        }
        if (length % 8 != 0) {
            int padding = 8 - length % 8;
            while (padding-- > 0) {
                buffer.getBoolean();
            }
        }
        return result;
    }

    private static int[] decodeArray(int[] elements, FieldType fieldType, BitBuffer buffer) {
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = (Integer)Types.decode(fieldType, buffer);
        }
        return elements;
    }

    private static long[] decodeArray(long[] elements, FieldType fieldType, BitBuffer buffer) {
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = (Long)Types.decode(fieldType, buffer);
        }
        return elements;
    }

    private static Object[] decodeArray(Object[] elements, FieldType fieldType, BitBuffer buffer) {
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = Types.decode(fieldType, buffer);
        }
        return elements;
    }

    public static Class<?> javaType(FieldType fieldType) {
        switch (fieldType) {
            case U_1: {
                return Boolean.TYPE;
            }
            case U_2: {
                return Integer.TYPE;
            }
            case U_1_V: {
                return BitList.class;
            }
            case U_8: {
                return Integer.TYPE;
            }
            case S_8: {
                return Integer.TYPE;
            }
            case U_8_V: {
                return int[].class;
            }
            case S_8_V: {
                return int[].class;
            }
            case UTF_8_V: {
                return String.class;
            }
            case U_16: {
                return Integer.TYPE;
            }
            case S_16: {
                return Integer.TYPE;
            }
            case U_16_V: {
                return int[].class;
            }
            case S_16_V: {
                return int[].class;
            }
            case U_32: {
                return Long.TYPE;
            }
            case S_32: {
                return Integer.TYPE;
            }
            case U_32_V: {
                return long[].class;
            }
            case S_32_V: {
                return int[].class;
            }
            case U_64: {
                return BigInteger.class;
            }
            case S_64: {
                return Long.TYPE;
            }
            case U_64_V: {
                return BigInteger[].class;
            }
            case S_64_V: {
                return BigInteger[].class;
            }
            case U_96: {
                return BigInteger.class;
            }
            case BYTES_TO_END: {
                return byte[].class;
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)fieldType));
    }

    public static <T> Class<T> wrap(Class<T> c) {
        return c.isPrimitive() ? PRIMITIVES_TO_WRAPPERS.get(c) : c;
    }

    static {
        PRIMITIVES_TO_WRAPPERS.put(Boolean.TYPE, Boolean.class);
        PRIMITIVES_TO_WRAPPERS.put(Byte.TYPE, Byte.class);
        PRIMITIVES_TO_WRAPPERS.put(Character.TYPE, Character.class);
        PRIMITIVES_TO_WRAPPERS.put(Double.TYPE, Double.class);
        PRIMITIVES_TO_WRAPPERS.put(Float.TYPE, Float.class);
        PRIMITIVES_TO_WRAPPERS.put(Integer.TYPE, Integer.class);
        PRIMITIVES_TO_WRAPPERS.put(Long.TYPE, Long.class);
        PRIMITIVES_TO_WRAPPERS.put(Short.TYPE, Short.class);
        PRIMITIVES_TO_WRAPPERS.put(Void.TYPE, Void.class);
    }
}

