/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.llrp4j.net;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import net.enilink.llrp4j.LlrpContext;
import net.enilink.llrp4j.net.IoHandler;
import net.enilink.llrp4j.net.IoSession;
import net.enilink.llrp4j.net.LlrpEndpoint;
import net.enilink.llrp4j.net.NioClient;
import net.enilink.llrp4j.types.LlrpMessage;

public class LlrpClient
implements Closeable {
    private NioClient nioClient;
    private IoHandler handler;

    protected LlrpClient(LlrpContext context, String host, int port, int timeout) throws IOException {
        this.handler = this.createHandler(context);
        this.nioClient = new NioClient(InetAddress.getByName(host), port, this.handler, timeout);
        new Thread(this.nioClient).start();
        this.handler.awaitConnectionAttemptEvent(timeout);
    }

    private IoHandler createHandler(LlrpContext context) {
        IoSession ioSession = new IoSession(){

            @Override
            public void send(ByteBuffer data) {
                LlrpClient.this.nioClient.send(data);
            }
        };
        return new IoHandler(context, ioSession, true, false);
    }

    public static LlrpClient create(LlrpContext context, String host) throws IOException {
        return LlrpClient.create(context, host, 5084);
    }

    public static LlrpClient create(LlrpContext context, String host, int port) throws IOException {
        return LlrpClient.create(context, host, 5084, 10000);
    }

    public static LlrpClient create(LlrpContext context, String host, int port, int timeout) throws IOException {
        return new LlrpClient(context, host, port, timeout);
    }

    public void send(LlrpMessage message) {
        this.handler.send(message);
    }

    public LlrpMessage transact(LlrpMessage message, long timeout) throws InterruptedException {
        return this.handler.transact(message, timeout);
    }

    public LlrpMessage transact(LlrpMessage message) throws InterruptedException {
        return this.transact(message, 10000L);
    }

    public LlrpClient endpoint(LlrpEndpoint endpoint) {
        this.handler.setEndpoint(endpoint);
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.nioClient != null) {
            this.nioClient.close();
            this.nioClient = null;
        }
    }
}

