/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.llrp4j;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import net.enilink.llrp4j.BinaryDecoder;
import net.enilink.llrp4j.BinaryEncoder;
import net.enilink.llrp4j.Module;
import net.enilink.llrp4j.XmlDecoder;
import net.enilink.llrp4j.XmlEncoder;
import net.enilink.llrp4j.annotations.LlrpCustomMessageType;
import net.enilink.llrp4j.annotations.LlrpCustomParameterType;
import net.enilink.llrp4j.annotations.LlrpMessageType;
import net.enilink.llrp4j.annotations.LlrpNamespace;
import net.enilink.llrp4j.annotations.LlrpParameterType;
import net.enilink.llrp4j.impl.BaseType;
import net.enilink.llrp4j.impl.CustomKey;
import net.enilink.llrp4j.impl.CustomMessage;
import net.enilink.llrp4j.impl.CustomParameter;
import net.enilink.llrp4j.impl.Message;
import net.enilink.llrp4j.impl.Parameter;

public class LlrpContext {
    protected final Set<Class<?>> classes = new HashSet();
    protected final Map<String, String> namespaces = new HashMap<String, String>();
    protected final Map<Integer, Message> messageTypes = new HashMap<Integer, Message>();
    protected final Map<Integer, Parameter> parameterTypes = new HashMap<Integer, Parameter>();
    protected final Map<CustomKey, CustomMessage> customMessageTypes = new HashMap<CustomKey, CustomMessage>();
    protected final Map<CustomKey, CustomParameter> customParameterTypes = new HashMap<CustomKey, CustomParameter>();
    protected final Map<AnnotationKey, Annotation> cachedAnnotations = new HashMap<AnnotationKey, Annotation>();
    protected final Map<QName, Class<?>> qnameToClass = new HashMap();
    static final String DEFAULT_NAMESPACE = "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0";

    protected LlrpContext(Module[] modules) {
        for (Module module : modules) {
            this.classes.addAll(module.getClasses());
            this.namespaces.putAll(module.getNamespaces());
        }
        HashSet<Package> packages = new HashSet<Package>();
        for (Class<?> c : this.classes) {
            this.addParameter(c);
            this.addMessage(c);
            this.addCustomMessage(c);
            this.addXmlType(c);
            packages.add(c.getPackage());
        }
    }

    private void addCustomMessage(Class<?> c) {
        LlrpCustomMessageType a = this.getAnnotation(c, LlrpCustomMessageType.class);
        if (a != null) {
            CustomKey key = new CustomKey(a.vendor(), a.subType());
            this.customMessageTypes.put(key, new CustomMessage(key, a, c));
        }
    }

    private void addMessage(Class<?> c) {
        LlrpMessageType a = this.getAnnotation(c, LlrpMessageType.class);
        if (a != null) {
            this.messageTypes.put(a.typeNum(), new Message(a, c));
        }
    }

    private void addParameter(Class<?> c) {
        LlrpCustomParameterType customAnnotation = this.getAnnotation(c, LlrpCustomParameterType.class);
        if (customAnnotation != null) {
            CustomKey key = new CustomKey(customAnnotation.vendor(), customAnnotation.subType());
            this.customParameterTypes.put(key, new CustomParameter(key, customAnnotation, c));
        } else {
            LlrpParameterType a = this.getAnnotation(c, LlrpParameterType.class);
            if (a != null) {
                this.parameterTypes.put(a.typeNum(), new Parameter(a, c));
            }
        }
    }

    private void addXmlType(Class<?> c) {
        LlrpNamespace a = this.getAnnotation(c, LlrpNamespace.class);
        if (a != null) {
            this.qnameToClass.put(new QName(a.value(), c.getSimpleName()), c);
        }
    }

    public static LlrpContext create(Module ... modules) {
        return new LlrpContext(modules);
    }

    public BinaryEncoder createBinaryEncoder() {
        return new BinaryEncoder(this);
    }

    public BinaryDecoder createBinaryDecoder() {
        return new BinaryDecoder(this);
    }

    public XmlDecoder createXmlDecoder() {
        return new XmlDecoder(this);
    }

    public XmlEncoder createXmlEncoder() {
        return this.createXmlEncoder(false);
    }

    public XmlEncoder createXmlEncoder(boolean indent) {
        return new XmlEncoder(this, indent);
    }

    public Collection<Class<?>> getClasses() {
        return Collections.unmodifiableCollection(this.classes);
    }

    CustomMessage customMessageType(Class<?> target) {
        LlrpCustomMessageType a = this.getAnnotation(target, LlrpCustomMessageType.class);
        if (a != null) {
            return this.customMessageTypes.get(new CustomKey(a.vendor(), a.subType()));
        }
        return null;
    }

    BaseType messageType(Class<?> target) {
        LlrpMessageType a = this.getAnnotation(target, LlrpMessageType.class);
        if (a != null) {
            return this.messageTypes.get(a.typeNum());
        }
        return this.customMessageType(target);
    }

    CustomParameter customParameterType(Class<?> target) {
        LlrpCustomParameterType a = this.getAnnotation(target, LlrpCustomParameterType.class);
        if (a != null) {
            return this.customParameterTypes.get(new CustomKey(a.vendor(), a.subType()));
        }
        return null;
    }

    Parameter parameterType(Class<?> target) {
        LlrpParameterType a = this.getAnnotation(target, LlrpParameterType.class);
        if (a != null) {
            return this.parameterTypes.get(a.typeNum());
        }
        return null;
    }

    protected <E extends Annotation> E getAnnotation(Class<?> target, Class<E> annotationClass) {
        if (target == null || Object.class.equals(target)) {
            return null;
        }
        AnnotationKey key = new AnnotationKey(target, annotationClass);
        Annotation cached = this.cachedAnnotations.get(key);
        if (cached != null) {
            return (E)cached;
        }
        E annotation = target.isAnnotationPresent(annotationClass) ? target.getAnnotation(annotationClass) : this.getAnnotation(target.getSuperclass(), annotationClass);
        if (annotation != null) {
            this.cachedAnnotations.put(key, (Annotation)annotation);
        }
        return annotation;
    }

    protected String xmlNamespace(Class<?> clazz) {
        LlrpNamespace ns = clazz.getAnnotation(LlrpNamespace.class);
        if (ns != null) {
            return ns.value();
        }
        return DEFAULT_NAMESPACE;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    static class AnnotationKey {
        final Class<?> targetClass;
        final Class<? extends Annotation> annotationClass;

        AnnotationKey(Class<?> targetClass, Class<? extends Annotation> annotationClass) {
            this.targetClass = targetClass;
            this.annotationClass = annotationClass;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.annotationClass == null ? 0 : this.annotationClass.hashCode());
            result = 31 * result + (this.targetClass == null ? 0 : this.targetClass.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AnnotationKey)) {
                return false;
            }
            AnnotationKey other = (AnnotationKey)obj;
            if (this.annotationClass == null ? other.annotationClass != null : !this.annotationClass.equals(other.annotationClass)) {
                return false;
            }
            return !(this.targetClass == null ? other.targetClass != null : !this.targetClass.equals(other.targetClass));
        }
    }
}

