/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.trees;

import java.util.Collection;
import java.util.HashSet;
import org.parboiled.common.Formatter;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Predicate;
import org.parboiled.common.Predicates;
import org.parboiled.trees.GraphNode;

public final class GraphUtils {
    private GraphUtils() {
    }

    public static boolean hasChildren(GraphNode<?> graphNode) {
        return graphNode != null && !graphNode.getChildren().isEmpty();
    }

    public static <T extends GraphNode<T>> T getFirstChild(T t) {
        return (T)(GraphUtils.hasChildren(t) ? (GraphNode)t.getChildren().get(0) : null);
    }

    public static <T extends GraphNode<T>> T getLastChild(T t) {
        return (T)(GraphUtils.hasChildren(t) ? (GraphNode)t.getChildren().get(t.getChildren().size() - 1) : null);
    }

    public static <T extends GraphNode<T>> int countAllDistinct(T t) {
        if (t == null) {
            return 0;
        }
        return GraphUtils.collectAllNodes(t, new HashSet()).size();
    }

    public static <T extends GraphNode<T>, C extends Collection<T>> C collectAllNodes(T t, C c) {
        Preconditions.checkArgNotNull(c, "collection");
        if (t != null && !c.contains(t)) {
            c.add(t);
            for (GraphNode graphNode : t.getChildren()) {
                GraphUtils.collectAllNodes(graphNode, c);
            }
        }
        return c;
    }

    public static <T extends GraphNode<T>> String printTree(T t, Formatter<T> formatter) {
        Preconditions.checkArgNotNull(formatter, "formatter");
        return GraphUtils.printTree(t, formatter, Predicates.alwaysTrue(), Predicates.alwaysTrue());
    }

    public static <T extends GraphNode<T>> String printTree(T t, Formatter<T> formatter, Predicate<T> predicate, Predicate<T> predicate2) {
        Preconditions.checkArgNotNull(formatter, "formatter");
        Preconditions.checkArgNotNull(predicate, "nodeFilter");
        Preconditions.checkArgNotNull(predicate2, "subTreeFilter");
        return t == null ? "" : GraphUtils.printTree(t, formatter, "", new StringBuilder(), predicate, predicate2).toString();
    }

    private static <T extends GraphNode<T>> StringBuilder printTree(T t, Formatter<T> formatter, String object, StringBuilder stringBuilder, Predicate<T> predicate, Predicate<T> predicate2) {
        Object object2;
        if (predicate.apply(t) && (object2 = formatter.format(t)) != null) {
            stringBuilder.append((String)object).append((String)object2).append("\n");
            object = (String)object + "  ";
        }
        if (predicate2.apply(t)) {
            for (GraphNode graphNode : t.getChildren()) {
                GraphUtils.printTree(graphNode, formatter, (String)object, stringBuilder, predicate, predicate2);
            }
        }
        return stringBuilder;
    }
}

