/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;
import org.parboiled.transform.Types;

class VarFramingGenerator
implements RuleMethodProcessor {
    VarFramingGenerator() {
    }

    @Override
    public boolean appliesTo(ParserClassNode parserClassNode, RuleMethod ruleMethod) {
        Preconditions.checkArgNotNull(parserClassNode, "classNode");
        Preconditions.checkArgNotNull(ruleMethod, "method");
        return ruleMethod.getLocalVarVariables() != null;
    }

    @Override
    public void process(ParserClassNode parserClassNode, RuleMethod ruleMethod) throws Exception {
        Preconditions.checkArgNotNull(parserClassNode, "classNode");
        Preconditions.checkArgNotNull(ruleMethod, "method");
        InsnList insnList = ruleMethod.instructions;
        AbstractInsnNode abstractInsnNode = insnList.getLast();
        while (abstractInsnNode.getOpcode() != 176) {
            abstractInsnNode = abstractInsnNode.getPrevious();
        }
        insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new TypeInsnNode(187, Types.VAR_FRAMING_MATCHER.getInternalName()));
        insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new InsnNode(90));
        insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new InsnNode(95));
        this.createVarFieldArray(ruleMethod, insnList, abstractInsnNode);
        insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new MethodInsnNode(183, Types.VAR_FRAMING_MATCHER.getInternalName(), "<init>", "(" + Types.RULE_DESC + "[" + Types.VAR_DESC + ")V", false));
        ruleMethod.setBodyRewritten();
    }

    private void createVarFieldArray(RuleMethod ruleMethod, InsnList insnList, AbstractInsnNode abstractInsnNode) {
        int n = ruleMethod.getLocalVarVariables().size();
        insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new IntInsnNode(16, n));
        insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new TypeInsnNode(189, Types.VAR.getInternalName()));
        for (int i = 0; i < n; ++i) {
            LocalVariableNode localVariableNode = ruleMethod.getLocalVarVariables().get(i);
            insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new InsnNode(89));
            insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new IntInsnNode(16, i));
            insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new VarInsnNode(25, localVariableNode.index));
            insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new InsnNode(89));
            insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new LdcInsnNode((Object)(ruleMethod.name + ":" + localVariableNode.name)));
            insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new MethodInsnNode(182, Types.VAR.getInternalName(), "setName", "(Ljava/lang/String;)V", false));
            insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new InsnNode(83));
        }
    }
}

