/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;

class ReturnInstructionUnifier
implements RuleMethodProcessor {
    ReturnInstructionUnifier() {
    }

    @Override
    public boolean appliesTo(ParserClassNode parserClassNode, RuleMethod ruleMethod) {
        return true;
    }

    @Override
    public void process(ParserClassNode parserClassNode, RuleMethod ruleMethod) throws Exception {
        Preconditions.checkArgNotNull(parserClassNode, "classNode");
        Preconditions.checkArgNotNull(ruleMethod, "method");
        if (ruleMethod.getNumberOfReturns() == 1) {
            return;
        }
        Preconditions.checkState(ruleMethod.getNumberOfReturns() > 1);
        AbstractInsnNode abstractInsnNode = ruleMethod.instructions.getLast();
        while (abstractInsnNode.getOpcode() != 176) {
            abstractInsnNode = abstractInsnNode.getPrevious();
        }
        LabelNode labelNode = new LabelNode();
        ruleMethod.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)labelNode);
        while ((abstractInsnNode = abstractInsnNode.getPrevious()) != null) {
            if (abstractInsnNode.getOpcode() != 176) continue;
            JumpInsnNode jumpInsnNode = new JumpInsnNode(167, labelNode);
            ruleMethod.instructions.set(abstractInsnNode, (AbstractInsnNode)jumpInsnNode);
            abstractInsnNode = jumpInsnNode;
        }
    }
}

