/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.common.Base64;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.InstructionGroup;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;

class InstructionGroupPreparer
implements RuleMethodProcessor {
    private static final Base64 CUSTOM_BASE64 = new Base64("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxy0123456789zzzz");
    private RuleMethod method;

    InstructionGroupPreparer() {
    }

    @Override
    public boolean appliesTo(ParserClassNode parserClassNode, RuleMethod ruleMethod) {
        Preconditions.checkArgNotNull(parserClassNode, "classNode");
        Preconditions.checkArgNotNull(ruleMethod, "method");
        return ruleMethod.containsExplicitActions() || ruleMethod.containsVars();
    }

    @Override
    public void process(ParserClassNode parserClassNode, RuleMethod ruleMethod) {
        this.method = Preconditions.checkArgNotNull(ruleMethod, "method");
        for (InstructionGroup instructionGroup : ruleMethod.getGroups()) {
            this.extractInstructions(instructionGroup);
            this.extractFields(instructionGroup);
            this.name(instructionGroup, parserClassNode);
        }
    }

    private void extractInstructions(InstructionGroup instructionGroup) {
        for (InstructionGraphNode instructionGraphNode : instructionGroup.getNodes()) {
            if (instructionGraphNode == instructionGroup.getRoot()) continue;
            AbstractInsnNode abstractInsnNode = instructionGraphNode.getInstruction();
            this.method.instructions.remove(abstractInsnNode);
            instructionGroup.getInstructions().add(abstractInsnNode);
        }
    }

    private void extractFields(InstructionGroup instructionGroup) {
        List<FieldNode> list = instructionGroup.getFields();
        for (InstructionGraphNode instructionGraphNode : instructionGroup.getNodes()) {
            int n;
            if (!instructionGraphNode.isXLoad()) continue;
            VarInsnNode varInsnNode = (VarInsnNode)instructionGraphNode.getInstruction();
            for (n = 0; n < list.size() && list.get((int)n).access != varInsnNode.var; ++n) {
            }
            if (n == list.size()) {
                Type type = instructionGraphNode.getResultValue().getType();
                list.add(new FieldNode(varInsnNode.var, "field$" + n, type.getDescriptor(), null, (Object)type));
            }
            varInsnNode.var = n;
        }
    }

    private synchronized void name(InstructionGroup instructionGroup, ParserClassNode parserClassNode) {
        Object object2;
        MD5Digester mD5Digester = new MD5Digester(parserClassNode.name);
        instructionGroup.getInstructions().accept((MethodVisitor)mD5Digester);
        for (Object object2 : instructionGroup.getFields()) {
            mD5Digester.visitField((FieldNode)object2);
        }
        Object object3 = mD5Digester.getMD5Hash();
        object2 = new byte[12];
        System.arraycopy(object3, 0, object2, 0, 12);
        Object object4 = instructionGroup.getRoot().isActionRoot() ? "Action$" : "VarInit$";
        object4 = (String)object4 + CUSTOM_BASE64.encodeToString((byte[])object2, false);
        instructionGroup.setName((String)object4);
    }

    private static class MD5Digester
    extends MethodVisitor {
        private static MessageDigest digest;
        private static ByteBuffer buffer;
        private final List<Label> labels = new ArrayList<Label>();
        private final String parserClassName;

        public MD5Digester(String string) {
            super(458752);
            this.parserClassName = string;
            if (digest == null) {
                try {
                    digest = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException(noSuchAlgorithmException);
                }
            }
            if (buffer == null) {
                buffer = ByteBuffer.allocateDirect(4096);
            }
            buffer.clear();
        }

        public void visitInsn(int n) {
            this.update(n);
        }

        public void visitIntInsn(int n, int n2) {
            this.update(n);
            this.update(n2);
        }

        public void visitVarInsn(int n, int n2) {
            this.update(n);
            this.update(n2);
            if (n == 25 && n2 == 0) {
                this.update(this.parserClassName);
            }
        }

        public void visitTypeInsn(int n, String string) {
            this.update(n);
            this.update(string);
        }

        public void visitFieldInsn(int n, String string, String string2, String string3) {
            this.update(n);
            this.update(string);
            this.update(string2);
            this.update(string3);
        }

        public void visitMethodInsn(int n, String string, String string2, String string3) {
            this.update(n);
            this.update(string);
            this.update(string2);
            this.update(string3);
        }

        public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
            this.visitMethodInsn(n, string, string2, string3);
        }

        public void visitJumpInsn(int n, Label label) {
            this.update(n);
            this.update(label);
        }

        public void visitLabel(Label label) {
            this.update(label);
        }

        public void visitLdcInsn(Object object) {
            if (object instanceof String) {
                this.update((String)object);
            } else if (object instanceof Integer) {
                this.update((Integer)object);
            } else if (object instanceof Float) {
                this.ensureRemaining(4);
                buffer.putFloat(((Float)object).floatValue());
            } else if (object instanceof Long) {
                this.ensureRemaining(8);
                buffer.putLong((Long)object);
            } else if (object instanceof Double) {
                this.ensureRemaining(8);
                buffer.putDouble((Double)object);
            } else {
                Preconditions.checkState(object instanceof Type);
                this.update(((Type)object).getInternalName());
            }
        }

        public void visitIincInsn(int n, int n2) {
            this.update(n);
            this.update(n2);
        }

        public void visitTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
            this.update(n);
            this.update(n2);
            this.update(label);
            for (Label label2 : labelArray) {
                this.update(label2);
            }
        }

        public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
            this.update(label);
            for (int i = 0; i < nArray.length; ++i) {
                this.update(nArray[i]);
                this.update(labelArray[i]);
            }
        }

        public void visitMultiANewArrayInsn(String string, int n) {
            this.update(string);
            this.update(n);
        }

        public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
            this.update(label);
            this.update(label2);
            this.update(label3);
            this.update(string);
        }

        public void visitField(FieldNode fieldNode) {
            this.update(fieldNode.name);
            this.update(fieldNode.desc);
            this.update(fieldNode.signature);
        }

        private void update(int n) {
            this.ensureRemaining(4);
            buffer.putInt(n);
        }

        private void update(String string) {
            if (StringUtils.isNotEmpty(string)) {
                int n = string.length();
                this.ensureRemaining(n * 2);
                for (int i = 0; i < n; ++i) {
                    buffer.putChar(string.charAt(i));
                }
            }
        }

        private void update(Label label) {
            int n = this.labels.indexOf(label);
            if (n == -1) {
                n = this.labels.size();
                this.labels.add(label);
            }
            this.update(n);
        }

        private void ensureRemaining(int n) {
            if (buffer.remaining() < n) {
                this.digest();
            }
        }

        private void digest() {
            buffer.flip();
            digest.update(buffer);
            buffer.clear();
        }

        public byte[] getMD5Hash() {
            this.digest();
            return digest.digest();
        }
    }
}

