/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.support.Checks;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.Types;

class ConstructorGenerator {
    ConstructorGenerator() {
    }

    public void process(ParserClassNode parserClassNode) {
        Preconditions.checkArgNotNull(parserClassNode, "classNode");
        Checks.ensure(!parserClassNode.getConstructors().isEmpty(), "Could not extend parser class '%s', no constructor visible to derived classes found", parserClassNode.getParentType().getClassName());
        for (MethodNode methodNode : parserClassNode.getConstructors()) {
            this.createConstuctor(parserClassNode, methodNode);
        }
        this.createNewInstanceMethod(parserClassNode);
    }

    private void createConstuctor(ParserClassNode parserClassNode, MethodNode methodNode) {
        MethodNode methodNode2 = new MethodNode(1, methodNode.name, methodNode.desc, methodNode.signature, methodNode.exceptions.toArray(new String[methodNode.exceptions.size()]));
        InsnList insnList = methodNode2.instructions;
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insnList.add(AsmUtils.createArgumentLoaders(methodNode.desc));
        insnList.add((AbstractInsnNode)new MethodInsnNode(183, parserClassNode.getParentType().getInternalName(), "<init>", methodNode.desc, parserClassNode.isInterface()));
        insnList.add((AbstractInsnNode)new InsnNode(177));
        parserClassNode.methods.add(methodNode2);
    }

    private void createNewInstanceMethod(ParserClassNode parserClassNode) {
        MethodNode methodNode = new MethodNode(1, "newInstance", "()L" + Types.BASE_PARSER.getInternalName() + ";", null, null);
        InsnList insnList = methodNode.instructions;
        insnList.add((AbstractInsnNode)new TypeInsnNode(187, parserClassNode.name));
        insnList.add((AbstractInsnNode)new InsnNode(89));
        insnList.add((AbstractInsnNode)new MethodInsnNode(183, parserClassNode.name, "<init>", "()V", parserClassNode.isInterface()));
        insnList.add((AbstractInsnNode)new InsnNode(176));
        parserClassNode.methods.add(methodNode);
    }
}

