/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import org.parboiled.common.Preconditions;

public final class IndexRange {
    public static final IndexRange EMPTY = new IndexRange(0, 0);
    public final int start;
    public final int end;

    public IndexRange(int n, int n2) {
        Preconditions.checkArgument(n >= 0, "start must be >= 0");
        Preconditions.checkArgument(n2 >= n, "end must be >= start");
        this.start = n;
        this.end = n2;
    }

    public boolean isEmpty() {
        return this.start == this.end;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean overlapsWith(IndexRange indexRange) {
        Preconditions.checkArgNotNull(indexRange, "other");
        return this.end > indexRange.start && indexRange.end > this.start;
    }

    public boolean isPrecededBy(IndexRange indexRange) {
        Preconditions.checkArgNotNull(indexRange, "other");
        return indexRange.end == this.start;
    }

    public boolean isFollowedBy(IndexRange indexRange) {
        Preconditions.checkArgNotNull(indexRange, "other");
        return this.end == indexRange.start;
    }

    public boolean touches(IndexRange indexRange) {
        Preconditions.checkArgNotNull(indexRange, "other");
        return indexRange.end == this.start || this.end == indexRange.start;
    }

    public IndexRange mergedWith(IndexRange indexRange) {
        Preconditions.checkArgNotNull(indexRange, "other");
        return new IndexRange(Math.min(this.start, indexRange.start), Math.max(this.end, indexRange.end));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IndexRange)) {
            return false;
        }
        IndexRange indexRange = (IndexRange)object;
        return this.end == indexRange.end && this.start == indexRange.start;
    }

    public int hashCode() {
        int n = this.start;
        n = 31 * n + this.end;
        return n;
    }

    public String toString() {
        return "IndexRange{start=" + this.start + ", end=" + this.end + "}";
    }
}

