/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.parboiled.common.ImmutableList;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.ActionClassGenerator;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.BodyWithSuperCallReplacer;
import org.parboiled.transform.CachingGenerator;
import org.parboiled.transform.ClassNodeInitializer;
import org.parboiled.transform.ConstructorGenerator;
import org.parboiled.transform.FlagMarkingGenerator;
import org.parboiled.transform.ImplicitActionsConverter;
import org.parboiled.transform.InstructionGraphCreator;
import org.parboiled.transform.InstructionGroupCreator;
import org.parboiled.transform.InstructionGroupPreparer;
import org.parboiled.transform.LabellingGenerator;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.ReturnInstructionUnifier;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;
import org.parboiled.transform.RuleMethodRewriter;
import org.parboiled.transform.SuperCallRewriter;
import org.parboiled.transform.UnusedLabelsRemover;
import org.parboiled.transform.VarFramingGenerator;
import org.parboiled.transform.VarInitClassGenerator;

public class ParserTransformer {
    private ParserTransformer() {
    }

    public static synchronized <T> Class<? extends T> transformParser(Class<T> clazz) throws Exception {
        Preconditions.checkArgNotNull(clazz, "parserClass");
        Class<?> clazz2 = AsmUtils.findLoadedClass(AsmUtils.getExtendedParserClassName(clazz.getName()), clazz.getClassLoader());
        return clazz2 != null ? clazz2 : ParserTransformer.extendParserClass(clazz).getExtendedClass();
    }

    static ParserClassNode extendParserClass(Class<?> clazz) throws Exception {
        ParserClassNode parserClassNode = new ParserClassNode(clazz);
        new ClassNodeInitializer().process(parserClassNode);
        ParserTransformer.runMethodTransformers(parserClassNode);
        new ConstructorGenerator().process(parserClassNode);
        ParserTransformer.defineExtendedParserClass(parserClassNode);
        return parserClassNode;
    }

    private static void runMethodTransformers(ParserClassNode parserClassNode) throws Exception {
        List<RuleMethodProcessor> list = ParserTransformer.createRuleMethodProcessors();
        for (RuleMethod ruleMethod : parserClassNode.getRuleMethods().values()) {
            if (ruleMethod.hasDontExtend()) continue;
            for (RuleMethodProcessor ruleMethodProcessor : list) {
                if (!ruleMethodProcessor.appliesTo(parserClassNode, ruleMethod)) continue;
                ruleMethodProcessor.process(parserClassNode, ruleMethod);
            }
        }
        for (RuleMethod ruleMethod : parserClassNode.getRuleMethods().values()) {
            if (ruleMethod.isGenerationSkipped()) continue;
            parserClassNode.methods.add(ruleMethod);
        }
    }

    static List<RuleMethodProcessor> createRuleMethodProcessors() {
        return ImmutableList.of(new RuleMethodProcessor[]{new UnusedLabelsRemover(), new ReturnInstructionUnifier(), new InstructionGraphCreator(), new ImplicitActionsConverter(), new InstructionGroupCreator(), new InstructionGroupPreparer(), new ActionClassGenerator(false), new VarInitClassGenerator(false), new RuleMethodRewriter(), new SuperCallRewriter(), new BodyWithSuperCallReplacer(), new VarFramingGenerator(), new LabellingGenerator(), new FlagMarkingGenerator(), new CachingGenerator()});
    }

    private static void defineExtendedParserClass(final ParserClassNode parserClassNode) {
        ClassWriter classWriter = new ClassWriter(2){

            protected ClassLoader getClassLoader() {
                return parserClassNode.getParentClass().getClassLoader();
            }
        };
        parserClassNode.accept((ClassVisitor)classWriter);
        parserClassNode.setClassCode(classWriter.toByteArray());
        parserClassNode.setExtendedClass(AsmUtils.loadClass(parserClassNode.name.replace('/', '.'), parserClassNode.getClassCode(), parserClassNode.getParentClass().getClassLoader()));
    }
}

