/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.subscription;

import java.util.Comparator;
import java.util.UUID;
import net.engio.mbassy.bus.IMessagePublication;
import net.engio.mbassy.common.IConcurrentSet;
import net.engio.mbassy.dispatch.IMessageDispatcher;
import net.engio.mbassy.subscription.SubscriptionContext;

public class Subscription {
    private final UUID id = UUID.randomUUID();
    protected final IConcurrentSet<Object> listeners;
    private final IMessageDispatcher dispatcher;
    private final SubscriptionContext context;
    public static final Comparator<Subscription> SubscriptionByPriorityDesc = new Comparator<Subscription>(){

        @Override
        public int compare(Subscription o1, Subscription o2) {
            int byPriority = Integer.valueOf(o2.getPriority()).compareTo(o1.getPriority());
            return byPriority == 0 ? o2.id.compareTo(o1.id) : byPriority;
        }
    };

    Subscription(SubscriptionContext context, IMessageDispatcher dispatcher, IConcurrentSet<Object> listeners) {
        this.context = context;
        this.dispatcher = dispatcher;
        this.listeners = listeners;
    }

    public boolean belongsTo(Class listener) {
        return this.context.getHandler().isFromListener(listener);
    }

    public boolean contains(Object listener) {
        return this.listeners.contains(listener);
    }

    public boolean handlesMessageType(Class<?> messageType) {
        return this.context.getHandler().handlesMessage(messageType);
    }

    public Class[] getHandledMessageTypes() {
        return this.context.getHandler().getHandledMessages();
    }

    public void publish(IMessagePublication publication, Object message) {
        if (this.listeners.size() > 0) {
            this.dispatcher.dispatch(publication, message, this.listeners);
        }
    }

    public int getPriority() {
        return this.context.getHandler().getPriority();
    }

    public void subscribe(Object o) {
        this.listeners.add(o);
    }

    public boolean unsubscribe(Object existingListener) {
        return this.listeners.remove(existingListener);
    }

    public int size() {
        return this.listeners.size();
    }
}

