/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.bus.error;

import java.lang.reflect.Method;
import net.engio.mbassy.bus.IMessagePublication;
import net.engio.mbassy.subscription.SubscriptionContext;

public class PublicationError {
    private Throwable cause;
    private String message;
    private Method handler;
    private Object listener;
    private Object publishedMessage;

    public PublicationError(Throwable cause, String message, Method handler, Object listener, Object publishedObject) {
        this.cause = cause;
        this.message = message;
        this.handler = handler;
        this.listener = listener;
        this.publishedMessage = publishedObject;
    }

    public PublicationError(Throwable cause, String message, IMessagePublication publication) {
        this.cause = cause;
        this.message = message;
        this.publishedMessage = publication != null ? publication.getMessage() : null;
    }

    public PublicationError(Throwable cause, String message, SubscriptionContext context) {
        this.cause = cause;
        this.message = message;
        this.handler = context.getHandler().getMethod();
    }

    public PublicationError() {
    }

    public Throwable getCause() {
        return this.cause;
    }

    public PublicationError setCause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public PublicationError setMessage(String message) {
        this.message = message;
        return this;
    }

    public Method getHandler() {
        return this.handler;
    }

    public PublicationError setHandler(Method handler) {
        this.handler = handler;
        return this;
    }

    public Object getListener() {
        return this.listener;
    }

    public PublicationError setListener(Object listener) {
        this.listener = listener;
        return this;
    }

    public Object getPublishedMessage() {
        return this.publishedMessage;
    }

    public PublicationError setPublishedMessage(Object publishedMessage) {
        this.publishedMessage = publishedMessage;
        return this;
    }

    public String toString() {
        String newLine = System.getProperty("line.separator");
        return "PublicationError{" + newLine + "\tcause=" + this.cause + newLine + "\tmessage='" + this.message + '\'' + newLine + "\thandler=" + this.handler + newLine + "\tlistener=" + this.listener + newLine + "\tpublishedMessage=" + this.publishedMessage + '}';
    }
}

