/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.engio.mbassy.common.IPredicate;

public class ReflectionUtils {
    public static List<Method> getMethods(IPredicate<Method> condition, Class<?> target) {
        LinkedList<Method> methods = new LinkedList<Method>();
        try {
            for (Method method : target.getDeclaredMethods()) {
                if (!condition.apply(method)) continue;
                methods.add(method);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!target.equals(Object.class)) {
            methods.addAll(ReflectionUtils.getMethods(condition, target.getSuperclass()));
        }
        return methods;
    }

    public static Method getOverridingMethod(Method overridingMethod, Class subclass) {
        Class current = subclass;
        while (!current.equals(overridingMethod.getDeclaringClass())) {
            try {
                return current.getDeclaredMethod(overridingMethod.getName(), overridingMethod.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                current = current.getSuperclass();
            }
        }
        return null;
    }

    public static Set<Class> getSuperclasses(Class from) {
        HashSet<Class> superclasses = new HashSet<Class>();
        ReflectionUtils.collectInterfaces(from, superclasses);
        while (!from.equals(Object.class) && !from.isInterface()) {
            superclasses.add(from.getSuperclass());
            from = from.getSuperclass();
            ReflectionUtils.collectInterfaces(from, superclasses);
        }
        return superclasses;
    }

    public static void collectInterfaces(Class from, Set<Class> accumulator) {
        for (Class<?> intface : from.getInterfaces()) {
            accumulator.add(intface);
            ReflectionUtils.collectInterfaces(intface, accumulator);
        }
    }

    public static boolean containsOverridingMethod(List<Method> allMethods, Method methodToCheck) {
        for (Method method : allMethods) {
            if (!ReflectionUtils.isOverriddenBy(methodToCheck, method)) continue;
            return true;
        }
        return false;
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationType) {
        return ReflectionUtils.getAnnotation((AnnotatedElement)method, annotationType);
    }

    public static <A extends Annotation> A getAnnotation(Class from, Class<A> annotationType) {
        return ReflectionUtils.getAnnotation((AnnotatedElement)from, annotationType);
    }

    public static <A extends Annotation> A getAnnotation(AnnotatedElement from, Class<A> annotationType) {
        A ann = from.getAnnotation(annotationType);
        if (ann == null) {
            Annotation metaAnn;
            Annotation[] arr$ = from.getAnnotations();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (ann = (metaAnn = arr$[i$]).annotationType().getAnnotation(annotationType)) == null; ++i$) {
            }
        }
        return ann;
    }

    private static boolean isOverriddenBy(Method superclassMethod, Method subclassMethod) {
        if (superclassMethod.getDeclaringClass().equals(subclassMethod.getDeclaringClass()) || !superclassMethod.getDeclaringClass().isAssignableFrom(subclassMethod.getDeclaringClass()) || !superclassMethod.getName().equals(subclassMethod.getName())) {
            return false;
        }
        Class<?>[] superClassMethodParameters = superclassMethod.getParameterTypes();
        Class<?>[] subClassMethodParameters = subclassMethod.getParameterTypes();
        for (int i = 0; i < subClassMethodParameters.length; ++i) {
            if (superClassMethodParameters[i].equals(subClassMethodParameters[i])) continue;
            return false;
        }
        return true;
    }
}

