/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.engio.mbassy.common.IPredicate;
import net.engio.mbassy.listener.Listener;
import net.engio.mbassy.listener.MessageHandlerMetadata;
import net.engio.mbassy.listener.References;

public class MessageListenerMetadata<T> {
    private List<MessageHandlerMetadata> handlers = new ArrayList<MessageHandlerMetadata>();
    private Class<T> listenerDefinition;
    private Listener listenerAnnotation;

    public static IPredicate<MessageHandlerMetadata> ForMessage(final Class<?> messageType) {
        return new IPredicate<MessageHandlerMetadata>(){

            @Override
            public boolean apply(MessageHandlerMetadata target) {
                return target.handlesMessage(messageType);
            }
        };
    }

    public MessageListenerMetadata(Class<T> listenerDefinition) {
        this.listenerDefinition = listenerDefinition;
        this.listenerAnnotation = listenerDefinition.getAnnotation(Listener.class);
    }

    public boolean isFromListener(Class listener) {
        return this.listenerDefinition.equals(listener);
    }

    public boolean useStrongReferences() {
        return this.listenerAnnotation != null && this.listenerAnnotation.references().equals((Object)References.Strong);
    }

    public MessageListenerMetadata addHandlers(Collection<? extends MessageHandlerMetadata> c) {
        this.handlers.addAll(c);
        return this;
    }

    public boolean addHandler(MessageHandlerMetadata messageHandlerMetadata) {
        return this.handlers.add(messageHandlerMetadata);
    }

    public List<MessageHandlerMetadata> getHandlers() {
        return this.handlers;
    }

    public List<MessageHandlerMetadata> getHandlers(IPredicate<MessageHandlerMetadata> filter) {
        LinkedList<MessageHandlerMetadata> matching = new LinkedList<MessageHandlerMetadata>();
        for (MessageHandlerMetadata handler : this.handlers) {
            if (!filter.apply(handler)) continue;
            matching.add(handler);
        }
        return matching;
    }

    public boolean handles(Class<?> messageType) {
        return !this.getHandlers(MessageListenerMetadata.ForMessage(messageType)).isEmpty();
    }

    public Class<T> getListerDefinition() {
        return this.listenerDefinition;
    }
}

