/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.dispatch;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.engio.mbassy.PublicationError;
import net.engio.mbassy.dispatch.HandlerInvocation;
import net.engio.mbassy.subscription.SubscriptionContext;

public class ReflectiveHandlerInvocation
extends HandlerInvocation {
    public ReflectiveHandlerInvocation(SubscriptionContext context) {
        super(context);
    }

    protected void invokeHandler(Object message, Object listener, Method handler) {
        try {
            handler.invoke(listener, message);
        }
        catch (IllegalAccessException e) {
            this.handlePublicationError(new PublicationError(e, "Error during invocation of message handler. The class or method is not accessible", handler, listener, message));
        }
        catch (IllegalArgumentException e) {
            this.handlePublicationError(new PublicationError(e, "Error during invocation of message handler. Wrong arguments passed to method. Was: " + message.getClass() + "Expected: " + handler.getParameterTypes()[0], handler, listener, message));
        }
        catch (InvocationTargetException e) {
            this.handlePublicationError(new PublicationError(e, "Error during invocation of message handler. Message handler threw exception", handler, listener, message));
        }
        catch (Throwable e) {
            this.handlePublicationError(new PublicationError(e, "Error during invocation of message handler. The handler code threw an exception", handler, listener, message));
        }
    }

    @Override
    public void invoke(Object listener, Object message) {
        this.invokeHandler(message, listener, this.getContext().getHandlerMetadata().getHandler());
    }
}

