/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.dispatch;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import net.engio.mbassy.IPublicationErrorHandler;
import net.engio.mbassy.PublicationError;
import net.engio.mbassy.dispatch.HandlerInvocation;
import net.engio.mbassy.subscription.SubscriptionContext;

public class ReflectiveHandlerInvocation
extends HandlerInvocation {
    public ReflectiveHandlerInvocation(SubscriptionContext context) {
        super(context);
    }

    protected void handlePublicationError(PublicationError error) {
        Collection<IPublicationErrorHandler> handlers = this.getContext().getOwningBus().getRegisteredErrorHandlers();
        for (IPublicationErrorHandler handler : handlers) {
            handler.handleError(error);
        }
    }

    protected void invokeHandler(Object message, Object listener, Method handler) {
        try {
            handler.invoke(listener, message);
        }
        catch (IllegalAccessException e) {
            this.handlePublicationError(new PublicationError(e, "Error during messageHandler notification. The class or method is not accessible", handler, listener, message));
        }
        catch (IllegalArgumentException e) {
            this.handlePublicationError(new PublicationError(e, "Error during messageHandler notification. Wrong arguments passed to method. Was: " + message.getClass() + "Expected: " + handler.getParameterTypes()[0], handler, listener, message));
        }
        catch (InvocationTargetException e) {
            this.handlePublicationError(new PublicationError(e, "Error during messageHandler notification. Message handler threw exception", handler, listener, message));
        }
        catch (Throwable e) {
            this.handlePublicationError(new PublicationError(e, "Error during messageHandler notification. Unexpected exception", handler, listener, message));
        }
    }

    @Override
    public void invoke(Object listener, Object message) {
        this.invokeHandler(message, listener, this.getContext().getHandlerMetadata().getHandler());
    }
}

