/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.common;

import java.util.Map;
import net.engio.mbassy.common.IConcurrentSet;
import net.engio.mbassy.common.ISetEntry;

public abstract class AbstractConcurrentSet<T>
implements IConcurrentSet<T> {
    private final Object lock = new Object();
    private final Map<T, ISetEntry<T>> entries;
    protected Entry<T> head;

    protected AbstractConcurrentSet(Map<T, ISetEntry<T>> entries) {
        this.entries = entries;
    }

    protected abstract Entry<T> createEntry(T var1, Entry<T> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IConcurrentSet<T> add(T element) {
        if (element == null || this.entries.containsKey(element)) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            this.insert(element);
        }
        return this;
    }

    @Override
    public boolean contains(T element) {
        ISetEntry<T> entry = this.entries.get(element);
        return entry != null && entry.getValue() != null;
    }

    private void insert(T element) {
        if (this.entries.containsKey(element)) {
            return;
        }
        this.head = this.createEntry(element, this.head);
        this.entries.put(element, this.head);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IConcurrentSet<T> addAll(Iterable<T> elements) {
        Object object = this.lock;
        synchronized (object) {
            for (T element : elements) {
                if (element == null || this.entries.containsKey(element)) {
                    return this;
                }
                this.insert(element);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(T element) {
        if (!this.entries.containsKey(element)) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            ISetEntry<T> listelement = this.entries.get(element);
            if (listelement == null) {
                return false;
            }
            if (listelement != this.head) {
                listelement.remove();
            } else {
                Entry<T> oldHead = this.head;
                this.head = this.head.next();
                oldHead.clear();
            }
            this.entries.remove(element);
        }
        return true;
    }

    public static abstract class Entry<T>
    implements ISetEntry<T> {
        private Entry<T> next;
        private Entry<T> predecessor;

        protected Entry(Entry<T> next) {
            this.next = next;
            next.predecessor = this;
        }

        protected Entry() {
        }

        @Override
        public void remove() {
            if (this.predecessor != null) {
                this.predecessor.next = this.next;
                if (this.next != null) {
                    this.next.predecessor = this.predecessor;
                }
            } else if (this.next != null) {
                this.next.predecessor = null;
            }
            this.next = null;
            this.predecessor = null;
        }

        @Override
        public Entry<T> next() {
            return this.next;
        }

        @Override
        public void clear() {
            this.next = null;
        }
    }
}

