/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.bus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.engio.mbassy.IPublicationErrorHandler;
import net.engio.mbassy.PublicationError;
import net.engio.mbassy.bus.BusConfiguration;
import net.engio.mbassy.bus.IMessageBus;
import net.engio.mbassy.bus.MessagePublication;
import net.engio.mbassy.common.ReflectionUtils;
import net.engio.mbassy.listener.MessageHandlerMetadata;
import net.engio.mbassy.listener.MetadataReader;
import net.engio.mbassy.subscription.Subscription;
import net.engio.mbassy.subscription.SubscriptionContext;
import net.engio.mbassy.subscription.SubscriptionFactory;

public abstract class AbstractMessageBus<T, P extends IMessageBus.IPostCommand>
implements IMessageBus<T, P> {
    private final ExecutorService executor;
    private final MetadataReader metadataReader;
    private final Map<Class, Collection<Subscription>> subscriptionsPerMessage = new HashMap<Class, Collection<Subscription>>(50);
    private final Map<Class, Collection<Subscription>> subscriptionsPerListener = new HashMap<Class, Collection<Subscription>>(50);
    private final Collection<Class> nonListeners = new HashSet<Class>();
    private final List<IPublicationErrorHandler> errorHandlers = new CopyOnWriteArrayList<IPublicationErrorHandler>();
    private final List<Thread> dispatchers = new CopyOnWriteArrayList<Thread>();
    private final BlockingQueue<MessagePublication> pendingMessages;
    private final SubscriptionFactory subscriptionFactory;
    private final MessagePublication.Factory publicationFactory;

    public AbstractMessageBus(BusConfiguration configuration) {
        this.executor = configuration.getExecutor();
        this.subscriptionFactory = configuration.getSubscriptionFactory();
        this.metadataReader = configuration.getMetadataReader();
        this.publicationFactory = configuration.getMessagePublicationFactory();
        this.pendingMessages = new LinkedBlockingQueue<MessagePublication>(configuration.getMaximumNumberOfPendingMessages());
        this.initDispatcherThreads(configuration.getNumberOfMessageDispatchers());
        this.addErrorHandler(new IPublicationErrorHandler.ConsoleLogger());
    }

    private void initDispatcherThreads(int numberOfThreads) {
        for (int i = 0; i < numberOfThreads; ++i) {
            Thread dispatcher = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            ((MessagePublication)AbstractMessageBus.this.pendingMessages.take()).execute();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            });
            dispatcher.setDaemon(true);
            this.dispatchers.add(dispatcher);
            dispatcher.start();
        }
    }

    protected MessagePublication.Factory getPublicationFactory() {
        return this.publicationFactory;
    }

    @Override
    public Collection<IPublicationErrorHandler> getRegisteredErrorHandlers() {
        return Collections.unmodifiableCollection(this.errorHandlers);
    }

    @Override
    public boolean unsubscribe(Object listener) {
        if (listener == null) {
            return false;
        }
        Collection<Subscription> subscriptions = this.subscriptionsPerListener.get(listener.getClass());
        if (subscriptions == null) {
            return false;
        }
        boolean isRemoved = true;
        for (Subscription subscription : subscriptions) {
            isRemoved = isRemoved && subscription.unsubscribe(listener);
        }
        return isRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(Object listener) {
        try {
            Class<?> listeningClass = listener.getClass();
            if (this.nonListeners.contains(listeningClass)) {
                return;
            }
            Collection<Subscription> subscriptionsByListener = this.subscriptionsPerListener.get(listeningClass);
            if (subscriptionsByListener == null) {
                AbstractMessageBus abstractMessageBus = this;
                synchronized (abstractMessageBus) {
                    subscriptionsByListener = this.subscriptionsPerListener.get(listeningClass);
                    if (subscriptionsByListener == null) {
                        List<MessageHandlerMetadata> messageHandlers = this.metadataReader.getMessageHandlers(listeningClass);
                        if (messageHandlers.isEmpty()) {
                            this.nonListeners.add(listeningClass);
                            return;
                        }
                        subscriptionsByListener = new ArrayList<Subscription>(messageHandlers.size());
                        for (MessageHandlerMetadata messageHandler : messageHandlers) {
                            Subscription subscription = this.subscriptionFactory.createSubscription(new SubscriptionContext(this, messageHandler));
                            subscription.subscribe(listener);
                            subscriptionsByListener.add(subscription);
                            List<Class<?>> messageTypes = messageHandler.getHandledMessages();
                            for (Class<?> messageType : messageTypes) {
                                this.addMessageTypeSubscription(messageType, subscription);
                            }
                        }
                        this.subscriptionsPerListener.put(listeningClass, subscriptionsByListener);
                    }
                }
            }
            for (Subscription sub : subscriptionsByListener) {
                sub.subscribe(listener);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addErrorHandler(IPublicationErrorHandler handler) {
        this.errorHandlers.add(handler);
    }

    protected MessagePublication addAsynchronousDeliveryRequest(MessagePublication request) {
        try {
            this.pendingMessages.put(request);
            return request.markScheduled();
        }
        catch (InterruptedException e) {
            return request.setError();
        }
    }

    protected MessagePublication addAsynchronousDeliveryRequest(MessagePublication request, long timeout, TimeUnit unit) {
        try {
            return this.pendingMessages.offer(request, timeout, unit) ? request.markScheduled() : request.setError();
        }
        catch (InterruptedException e) {
            return request.setError();
        }
    }

    protected Collection<Subscription> getSubscriptionsByMessageType(Class messageType) {
        TreeSet<Subscription> subscriptions = new TreeSet<Subscription>(Subscription.SubscriptionByPriorityDesc);
        if (this.subscriptionsPerMessage.get(messageType) != null) {
            subscriptions.addAll(this.subscriptionsPerMessage.get(messageType));
        }
        for (Class eventSuperType : ReflectionUtils.getSuperclasses(messageType)) {
            Collection<Subscription> subs = this.subscriptionsPerMessage.get(eventSuperType);
            if (subs == null) continue;
            for (Subscription sub : subs) {
                if (!sub.handlesMessageType(messageType)) continue;
                subscriptions.add(sub);
            }
        }
        return subscriptions;
    }

    private void addMessageTypeSubscription(Class messageType, Subscription subscription) {
        Collection<Subscription> subscriptions = this.subscriptionsPerMessage.get(messageType);
        if (subscriptions == null) {
            subscriptions = new LinkedList<Subscription>();
            this.subscriptionsPerMessage.put(messageType, subscriptions);
        }
        subscriptions.add(subscription);
    }

    public void handlePublicationError(PublicationError error) {
        for (IPublicationErrorHandler errorHandler : this.errorHandlers) {
            errorHandler.handleError(error);
        }
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    private void shutdown() {
        for (Thread dispatcher : this.dispatchers) {
            dispatcher.interrupt();
        }
        this.executor.shutdown();
    }

    @Override
    public boolean hasPendingMessages() {
        return this.pendingMessages.size() > 0;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }
}

